/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.common.exception;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
public class GlobalExceptionResolver
implements HandlerExceptionResolver {
    @Autowired
    private SystemService systemService;
    private static final Logger log = Logger.getLogger(GlobalExceptionResolver.class);
    private static final int WIRTE_DB_MAX_LENGTH = 1500;
    private static final short LOG_LEVEL = 6;
    private static final short LOG_OPT = 3;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        boolean isajax = this.isAjax(request, response);
        Throwable deepestException = this.deepestException(ex);
        return this.processException(request, response, handler, deepestException, isajax);
    }

    private boolean isAjax(HttpServletRequest request, HttpServletResponse response) {
        return oConvertUtils.isNotEmpty(request.getHeader("X-Requested-With"));
    }

    private Throwable deepestException(Throwable e) {
        Throwable tmp = e;
        int breakPoint = 0;
        while (tmp.getCause() != null) {
            if (tmp.equals(tmp.getCause())) break;
            tmp = tmp.getCause();
            if (++breakPoint > 1000) break;
        }
        return tmp;
    }

    private ModelAndView processException(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable ex, boolean isajax) {
        log.error((Object)"\u5168\u5c40\u5904\u7406\u5f02\u5e38\u6355\u83b7:", ex);
        this.logDb(ex);
        if (ex.toString().indexOf("/licController.do") != -1) {
            return null;
        }
        if (isajax) {
            return this.processAjax(request, response, handler, ex);
        }
        return this.processNotAjax(request, response, handler, ex);
    }

    private void logDb(Throwable ex) {
        String exceptionMessage = "\u9519\u8bef\u5f02\u5e38: " + ex.getClass().getSimpleName() + ",\u9519\u8bef\u63cf\u8ff0\uff1a" + ex.getMessage();
        if (oConvertUtils.isNotEmpty(exceptionMessage) && exceptionMessage.length() > 1500) {
            exceptionMessage = exceptionMessage.substring(0, 1500);
        }
        this.systemService.addLog(exceptionMessage, (short)6, (short)3);
    }

    private ModelAndView processAjax(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable deepestException) {
        ModelAndView empty = new ModelAndView();
        response.setHeader("Cache-Control", "no-store");
        AjaxJson json = new AjaxJson();
        json.setSuccess(true);
        String errormsg = "\u5f88\u62b1\u6b49\uff0c\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
        try {
            Gson gson = new Gson();
            Map error = (Map)gson.fromJson(deepestException.getMessage(), Map.class);
            if (error.containsKey("errcode")) {
                errormsg = String.valueOf(errormsg) + "\u3000\u9519\u8bef\u7801:" + error.get("errcode");
            }
        }
        catch (Exception gson) {
            // empty catch block
        }
        json.setMsg(errormsg);
        try {
            PrintWriter pw = response.getWriter();
            pw.write(JSONHelper.bean2json(json));
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        empty.clear();
        return empty;
    }

    private ModelAndView processNotAjax(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable ex) {
        String exceptionMessage = this.getThrowableMessage(ex);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("exceptionMessage", exceptionMessage);
        model.put("ex", ex);
        return new ModelAndView("common/sys/404", model);
    }

    public String getThrowableMessage(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }
}

