/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.common.dao.jdbc;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.poi.ss.formula.functions.T;
import org.jeecgframework.core.common.dao.jdbc.SimpleJdbcTemplate;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Repository;

@Repository(value="jdbcDao")
public class JdbcDao
extends SimpleJdbcTemplate {
    public static final String DATABSE_TYPE_MYSQL = "mysql";
    public static final String DATABSE_TYPE_POSTGRE = "postgresql";
    public static final String DATABSE_TYPE_ORACLE = "oracle";
    public static final String DATABSE_TYPE_SQLSERVER = "sqlserver";
    public static final String MYSQL_SQL = "select * from ( {0}) sel_tab00 limit {1},{2}";
    public static final String POSTGRE_SQL = "select * from ( {0}) sel_tab00 limit {2} offset {1}";
    public static final String ORACLE_SQL = "select * from (select row_.*,rownum rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}";
    public static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}";

    @Autowired
    public JdbcDao(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public List find(String sql, Class clazz, Map parameters) {
        return super.find(sql, clazz, parameters);
    }

    @Override
    public Object findForObject(String sql, Class clazz, Map parameters) {
        return super.findForObject(sql, clazz, parameters);
    }

    @Override
    public long findForLong(String sql, Map parameters) {
        return super.findForLong(sql, parameters);
    }

    @Override
    public Map findForMap(String sql, Map parameters) {
        return super.findForMap(sql, parameters);
    }

    @Override
    public List<Map<String, Object>> findForListMap(String sql, Map parameters) {
        return super.findForListMap(sql, parameters);
    }

    @Override
    public int executeForObject(String sql, Object bean) {
        return super.executeForObject(sql, bean);
    }

    @Override
    public int executeForMap(String sql, Map parameters) {
        return super.executeForMap(sql, parameters);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batch) {
        return super.batchUpdate(sql, batch);
    }

    public List<Map<String, Object>> findForJdbc(String sql, int page, int rows) {
        sql = JdbcDao.jeecgCreatePageSql(sql, page, rows);
        return this.jdbcTemplate.queryForList(sql, new Object[0]);
    }

    public List<Map<String, Object>> findForJdbc(String sql, Object ... objs) {
        return this.jdbcTemplate.queryForList(sql, objs);
    }

    public List<T> findObjForJdbc(String sql, int page, int rows, Class<T> clazz) {
        ArrayList<T> rsList = new ArrayList<T>();
        sql = JdbcDao.jeecgCreatePageSql(sql, page, rows);
        List mapList = this.jdbcTemplate.queryForList(sql, new Object[0]);
        T po = null;
        for (Map m : mapList) {
            try {
                po = clazz.newInstance();
                MyBeanUtils.copyMap2Bean_Nobig(po, m);
                rsList.add(po);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rsList;
    }

    public List<Map<String, Object>> findForJdbcParam(String sql, int page, int rows, Object ... objs) {
        sql = JdbcDao.jeecgCreatePageSql(sql, page, rows);
        return this.jdbcTemplate.queryForList(sql, objs);
    }

    public Map<String, Object> findOneForJdbc(String sql, Object ... objs) {
        try {
            return this.jdbcTemplate.queryForMap(sql, objs);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Long getCountForJdbc(String sql) {
        return this.jdbcTemplate.queryForLong(sql, new Object[0]);
    }

    public Long getCountForJdbcParam(String sql, Object ... objs) {
        return this.jdbcTemplate.queryForLong(sql, objs);
    }

    public Integer executeSql2(String sql, List<Object> param) {
        return this.jdbcTemplate.update(sql, new Object[]{param});
    }

    public Integer executeSql(String sql, Object ... param) {
        return this.jdbcTemplate.update(sql, param);
    }

    public Integer countByJdbc(String sql, Object ... param) {
        return this.jdbcTemplate.queryForInt(sql, param);
    }

    public static String jeecgCreatePageSql(String sql, int page, int rows) {
        int beginNum = (page - 1) * rows;
        Object[] sqlParam = new String[]{sql, String.valueOf(beginNum), String.valueOf(rows)};
        if (ResourceUtil.getJdbcUrl().indexOf(DATABSE_TYPE_MYSQL) != -1) {
            sql = MessageFormat.format(MYSQL_SQL, sqlParam);
        } else if (ResourceUtil.getJdbcUrl().indexOf(DATABSE_TYPE_POSTGRE) != -1) {
            sql = MessageFormat.format(POSTGRE_SQL, sqlParam);
        } else {
            int beginIndex = (page - 1) * rows;
            int endIndex = beginIndex + rows;
            sqlParam[2] = Integer.toString(beginIndex);
            sqlParam[1] = Integer.toString(endIndex);
            if (ResourceUtil.getJdbcUrl().indexOf(DATABSE_TYPE_ORACLE) != -1) {
                sql = MessageFormat.format(ORACLE_SQL, sqlParam);
            } else if (ResourceUtil.getJdbcUrl().indexOf(DATABSE_TYPE_SQLSERVER) != -1) {
                sqlParam[0] = sql.substring(JdbcDao.getAfterSelectInsertPoint(sql));
                sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
            }
        }
        return sql;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }
}

