/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.common.dao.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.jeecgframework.core.annotation.JeecgEntityTitle;
import org.jeecgframework.core.common.dao.IGenericBaseCommonDao;
import org.jeecgframework.core.common.dao.jdbc.JdbcDao;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.hibernate.qbc.DetachedCriteriaUtil;
import org.jeecgframework.core.common.hibernate.qbc.HqlQuery;
import org.jeecgframework.core.common.hibernate.qbc.PageList;
import org.jeecgframework.core.common.hibernate.qbc.PagerUtil;
import org.jeecgframework.core.common.model.common.DBTable;
import org.jeecgframework.core.common.model.json.DataGridReturn;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ToEntityUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.vo.datatable.DataTableReturn;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.Assert;

public abstract class GenericBaseCommonDao<T, PK extends Serializable>
implements IGenericBaseCommonDao {
    private static final Logger logger = Logger.getLogger(GenericBaseCommonDao.class);
    @Autowired
    @Qualifier(value="sessionFactory")
    private SessionFactory sessionFactory;
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    @Qualifier(value="namedParameterJdbcTemplate")
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    private <T> void getProperty(Class entityName) {
        ClassMetadata cm = this.sessionFactory.getClassMetadata(entityName);
        String[] str = cm.getPropertyNames();
        int i = 0;
        while (i < str.length) {
            String property = str[i];
            String type = cm.getPropertyType(property).getName();
            LogUtil.info(String.valueOf(property) + "---&gt;" + type);
            ++i;
        }
    }

    @Override
    public List<DBTable> getAllDbTableName() {
        ArrayList<DBTable> resultList = new ArrayList<DBTable>();
        SessionFactory factory = this.getSession().getSessionFactory();
        Map metaMap = factory.getAllClassMetadata();
        for (String key : metaMap.keySet()) {
            DBTable dbTable = new DBTable();
            AbstractEntityPersister classMetadata = (AbstractEntityPersister)metaMap.get(key);
            dbTable.setTableName(classMetadata.getTableName());
            dbTable.setEntityName(classMetadata.getEntityName());
            try {
                Class<?> c = Class.forName(key);
                JeecgEntityTitle t = c.getAnnotation(JeecgEntityTitle.class);
                dbTable.setTableTitle(t != null ? t.name() : "");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            resultList.add(dbTable);
        }
        return resultList;
    }

    @Override
    public Integer getAllDbTableSize() {
        SessionFactory factory = this.getSession().getSessionFactory();
        Map metaMap = factory.getAllClassMetadata();
        return metaMap.size();
    }

    @Override
    public <T> T findUniqueByProperty(Class<T> entityClass, String propertyName, Object value) {
        Assert.hasText((String)propertyName);
        return (T)this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).uniqueResult();
    }

    @Override
    public <T> List<T> findByProperty(Class<T> entityClass, String propertyName, Object value) {
        Assert.hasText((String)propertyName);
        return this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).list();
    }

    @Override
    public <T> Serializable save(T entity) {
        try {
            Serializable id = this.getSession().save(entity);
            this.getSession().flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u4fdd\u5b58\u5b9e\u4f53\u6210\u529f," + entity.getClass().getName()));
            }
            return id;
        }
        catch (RuntimeException e) {
            logger.error((Object)"\u4fdd\u5b58\u5b9e\u4f53\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void batchSave(List<T> entitys) {
        int i = 0;
        while (i < entitys.size()) {
            this.getSession().save(entitys.get(i));
            if (i % 20 == 0) {
                this.getSession().flush();
                this.getSession().clear();
            }
            ++i;
        }
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        try {
            this.getSession().saveOrUpdate(entity);
            this.getSession().flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6dfb\u52a0\u6216\u66f4\u65b0\u6210\u529f," + entity.getClass().getName()));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"\u6dfb\u52a0\u6216\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void delete(T entity) {
        try {
            this.getSession().delete(entity);
            this.getSession().flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5220\u9664\u6210\u529f," + entity.getClass().getName()));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"\u5220\u9664\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void deleteEntityById(Class entityName, Serializable id) {
        this.delete(this.get(entityName, id));
        this.getSession().flush();
    }

    @Override
    public <T> void deleteAllEntitie(Collection<T> entitys) {
        for (T entity : entitys) {
            this.getSession().delete(entity);
            this.getSession().flush();
        }
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id) {
        return (T)this.getSession().get(entityClass, id);
    }

    @Override
    public <T> T getEntity(Class entityName, Serializable id) {
        Object t = this.getSession().get(entityName, id);
        if (t != null) {
            this.getSession().flush();
        }
        return (T)t;
    }

    @Override
    public <T> void updateEntitie(T pojo) {
        this.getSession().update(pojo);
        this.getSession().flush();
    }

    public <T> void updateEntitie(String className, Object id) {
        this.getSession().update(className, id);
        this.getSession().flush();
    }

    @Override
    public <T> void updateEntityById(Class entityName, Serializable id) {
        this.updateEntitie(this.get(entityName, id));
    }

    @Override
    public List<T> findByQueryString(String query) {
        Query queryObject = this.getSession().createQuery(query);
        List list = queryObject.list();
        if (list.size() > 0) {
            this.getSession().flush();
        }
        return list;
    }

    @Override
    public <T> T singleResult(String hql) {
        T t = null;
        Query queryObject = this.getSession().createQuery(hql);
        List list = queryObject.list();
        if (list.size() == 1) {
            this.getSession().flush();
            t = (T)list.get(0);
        } else if (list.size() > 0) {
            throw new BusinessException("\u67e5\u8be2\u7ed3\u679c\u6570:" + list.size() + "\u5927\u4e8e1");
        }
        return t;
    }

    @Override
    public Map<Object, Object> getHashMapbyQuery(String hql) {
        Query query = this.getSession().createQuery(hql);
        List list = query.list();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object[] tm : list) {
            map.put(tm[0].toString(), tm[1].toString());
        }
        return map;
    }

    @Override
    public int updateBySqlString(String query) {
        SQLQuery querys = this.getSession().createSQLQuery(query);
        return querys.executeUpdate();
    }

    @Override
    public List<T> findListbySql(String sql) {
        SQLQuery querys = this.getSession().createSQLQuery(sql);
        return querys.list();
    }

    private <T> Criteria createCriteria(Class<T> entityClass, boolean isAsc, Criterion ... criterions) {
        Criteria criteria = this.createCriteria(entityClass, criterions);
        if (isAsc) {
            criteria.addOrder(Order.asc((String)"asc"));
        } else {
            criteria.addOrder(Order.desc((String)"desc"));
        }
        return criteria;
    }

    private <T> Criteria createCriteria(Class<T> entityClass, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        Criterion[] criterionArray = criterions;
        int n = criterions.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        return criteria;
    }

    @Override
    public <T> List<T> loadAll(Class<T> entityClass) {
        Criteria criteria = this.createCriteria(entityClass);
        return criteria.list();
    }

    private <T> Criteria createCriteria(Class<T> entityClass) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        return criteria;
    }

    @Override
    public <T> List<T> findByPropertyisOrder(Class<T> entityClass, String propertyName, Object value, boolean isAsc) {
        Assert.hasText((String)propertyName);
        return this.createCriteria(entityClass, isAsc, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).list();
    }

    public <T> T findUniqueBy(Class<T> entityClass, String propertyName, Object value) {
        Assert.hasText((String)propertyName);
        return (T)this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).uniqueResult();
    }

    public Query createQuery(Session session, String hql, Object ... objects) {
        Query query = session.createQuery(hql);
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                query.setParameter(i, objects[i]);
                ++i;
            }
        }
        return query;
    }

    public <T> int batchInsertsEntitie(List<T> entityList) {
        int num = 0;
        int i = 0;
        while (i < entityList.size()) {
            this.save(entityList.get(i));
            ++num;
            ++i;
        }
        return num;
    }

    public List<T> executeQuery(String hql, Object[] values) {
        Query query = this.getSession().createQuery(hql);
        int i = 0;
        while (values != null && i < values.length) {
            query.setParameter(i, values[i]);
            ++i;
        }
        return query.list();
    }

    @Override
    public List findByExample(String entityName, Object exampleEntity) {
        Assert.notNull((Object)exampleEntity, (String)"Example entity must not be null");
        Criteria executableCriteria = entityName != null ? this.getSession().createCriteria(entityName) : this.getSession().createCriteria(exampleEntity.getClass());
        executableCriteria.add((Criterion)Example.create((Object)exampleEntity));
        return executableCriteria.list();
    }

    public Integer getRowCount(DetachedCriteria criteria) {
        return oConvertUtils.getInt(((Criteria)criteria.setProjection(Projections.rowCount())).uniqueResult(), 0);
    }

    public void callableStatementByName(String proc) {
    }

    public int getCount(Class<T> clazz) {
        int count = DataAccessUtils.intResult((Collection)this.getSession().createQuery("select count(*) from " + clazz.getName()).list());
        return count;
    }

    @Override
    public PageList getPageList(CriteriaQuery cq, boolean isOffset) {
        Criteria criteria = cq.getDetachedCriteria().getExecutableCriteria(this.getSession());
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Projection projection = impl.getProjection();
        int allCounts = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        criteria.setProjection(projection);
        if (projection == null) {
            criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (CriteriaQuery.getOrdermap() != null) {
            cq.setOrder(CriteriaQuery.getOrdermap());
        }
        int pageSize = cq.getPageSize();
        int curPageNO = PagerUtil.getcurPageNo(allCounts, cq.getCurPage(), pageSize);
        int offset = PagerUtil.getOffset(allCounts, curPageNO, pageSize);
        String toolBar = "";
        if (isOffset) {
            criteria.setFirstResult(offset);
            criteria.setMaxResults(cq.getPageSize());
            toolBar = cq.getIsUseimage() == 1 ? PagerUtil.getBar(cq.getMyAction(), cq.getMyForm(), allCounts, curPageNO, pageSize, cq.getMap()) : PagerUtil.getBar(cq.getMyAction(), allCounts, curPageNO, pageSize, cq.getMap());
        } else {
            pageSize = allCounts;
        }
        return new PageList(criteria.list(), toolBar, offset, curPageNO, allCounts);
    }

    @Override
    public DataTableReturn getDataTableReturn(CriteriaQuery cq, boolean isOffset) {
        Criteria criteria = cq.getDetachedCriteria().getExecutableCriteria(this.getSession());
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Projection projection = impl.getProjection();
        int allCounts = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        criteria.setProjection(projection);
        if (projection == null) {
            criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (CriteriaQuery.getOrdermap() != null) {
            cq.setOrder(CriteriaQuery.getOrdermap());
        }
        int pageSize = cq.getPageSize();
        int curPageNO = PagerUtil.getcurPageNo(allCounts, cq.getCurPage(), pageSize);
        int offset = PagerUtil.getOffset(allCounts, curPageNO, pageSize);
        if (isOffset) {
            criteria.setFirstResult(offset);
            criteria.setMaxResults(cq.getPageSize());
        } else {
            pageSize = allCounts;
        }
        DetachedCriteriaUtil.selectColumn(cq.getDetachedCriteria(), cq.getField().split(","), cq.getEntityClass(), false);
        return new DataTableReturn(allCounts, allCounts, cq.getDataTables().getEcho(), criteria.list());
    }

    @Override
    public DataGridReturn getDataGridReturn(CriteriaQuery cq, boolean isOffset) {
        Criteria criteria = cq.getDetachedCriteria().getExecutableCriteria(this.getSession());
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Projection projection = impl.getProjection();
        int allCounts = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        criteria.setProjection(projection);
        if (projection == null) {
            criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (StringUtils.isNotBlank((String)cq.getDataGrid().getSort())) {
            cq.addOrder(cq.getDataGrid().getSort(), cq.getDataGrid().getOrder());
        }
        if (!CriteriaQuery.getOrdermap().isEmpty()) {
            cq.setOrder(CriteriaQuery.getOrdermap());
        }
        int pageSize = cq.getPageSize();
        int curPageNO = PagerUtil.getcurPageNo(allCounts, cq.getCurPage(), pageSize);
        int offset = PagerUtil.getOffset(allCounts, curPageNO, pageSize);
        if (isOffset) {
            criteria.setFirstResult(offset);
            criteria.setMaxResults(cq.getPageSize());
        } else {
            pageSize = allCounts;
        }
        List list = criteria.list();
        cq.getDataGrid().setResults(list);
        cq.getDataGrid().setTotal(allCounts);
        return new DataGridReturn(allCounts, list);
    }

    @Override
    public PageList getPageListBySql(HqlQuery hqlQuery, boolean isToEntity) {
        SQLQuery query = this.getSession().createSQLQuery(hqlQuery.getQueryString());
        int allCounts = query.list().size();
        int curPageNO = hqlQuery.getCurPage();
        int offset = PagerUtil.getOffset(allCounts, curPageNO, hqlQuery.getPageSize());
        query.setFirstResult(offset);
        query.setMaxResults(hqlQuery.getPageSize());
        List list = null;
        list = isToEntity ? (List)ToEntityUtil.toEntityList(query.list(), hqlQuery.getClass1(), hqlQuery.getDataGrid().getField().split(",")) : query.list();
        return new PageList(hqlQuery, list, offset, curPageNO, allCounts);
    }

    @Override
    public PageList getPageList(HqlQuery hqlQuery, boolean needParameter) {
        Query query = this.getSession().createQuery(hqlQuery.getQueryString());
        if (needParameter) {
            query.setParameters(hqlQuery.getParam(), hqlQuery.getTypes());
        }
        int allCounts = query.list().size();
        int curPageNO = hqlQuery.getCurPage();
        int offset = PagerUtil.getOffset(allCounts, curPageNO, hqlQuery.getPageSize());
        String toolBar = PagerUtil.getBar(hqlQuery.getMyaction(), allCounts, curPageNO, hqlQuery.getPageSize(), hqlQuery.getMap());
        query.setFirstResult(offset);
        query.setMaxResults(hqlQuery.getPageSize());
        return new PageList(query.list(), toolBar, offset, curPageNO, allCounts);
    }

    @Override
    public List<T> getListByCriteriaQuery(CriteriaQuery cq, Boolean ispage) {
        Criteria criteria = cq.getDetachedCriteria().getExecutableCriteria(this.getSession());
        if (CriteriaQuery.getOrdermap() != null) {
            cq.setOrder(CriteriaQuery.getOrdermap());
        }
        if (ispage.booleanValue()) {
            criteria.setFirstResult((cq.getCurPage() - 1) * cq.getPageSize());
            criteria.setMaxResults(cq.getPageSize());
        }
        return criteria.list();
    }

    @Override
    public List<Map<String, Object>> findForJdbc(String sql, int page, int rows) {
        sql = JdbcDao.jeecgCreatePageSql(sql, page, rows);
        return this.jdbcTemplate.queryForList(sql);
    }

    @Override
    public <T> List<T> findObjForJdbc(String sql, int page, int rows, Class<T> clazz) {
        ArrayList<Object> rsList = new ArrayList<Object>();
        sql = JdbcDao.jeecgCreatePageSql(sql, page, rows);
        List mapList = this.jdbcTemplate.queryForList(sql);
        Object po = null;
        for (Map m : mapList) {
            try {
                po = clazz.newInstance();
                MyBeanUtils.copyMap2Bean_Nobig(po, m);
                rsList.add(po);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rsList;
    }

    @Override
    public List<Map<String, Object>> findForJdbcParam(String sql, int page, int rows, Object ... objs) {
        sql = JdbcDao.jeecgCreatePageSql(sql, page, rows);
        return this.jdbcTemplate.queryForList(sql, objs);
    }

    @Override
    public Long getCountForJdbc(String sql) {
        return this.jdbcTemplate.queryForLong(sql);
    }

    @Override
    public Long getCountForJdbcParam(String sql, Object[] objs) {
        return this.jdbcTemplate.queryForLong(sql, objs);
    }

    @Override
    public List<Map<String, Object>> findForJdbc(String sql, Object ... objs) {
        return this.jdbcTemplate.queryForList(sql, objs);
    }

    @Override
    public Integer executeSql(String sql, List<Object> param) {
        return this.jdbcTemplate.update(sql, new Object[]{param});
    }

    @Override
    public Integer executeSql(String sql, Object ... param) {
        return this.jdbcTemplate.update(sql, param);
    }

    @Override
    public Integer executeSql(String sql, Map<String, Object> param) {
        return this.namedParameterJdbcTemplate.update(sql, param);
    }

    @Override
    public Object executeSqlReturnKey(String sql, Map<String, Object> param) {
        Long keyValue = null;
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        MapSqlParameterSource sqlp = new MapSqlParameterSource(param);
        this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)sqlp, (KeyHolder)keyHolder);
        if (oConvertUtils.isNotEmpty(keyHolder.getKey())) {
            keyValue = keyHolder.getKey().longValue();
        }
        return keyValue;
    }

    public Integer countByJdbc(String sql, Object ... param) {
        return this.jdbcTemplate.queryForInt(sql, param);
    }

    @Override
    public Map<String, Object> findOneForJdbc(String sql, Object ... objs) {
        try {
            return this.jdbcTemplate.queryForMap(sql, objs);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> List<T> findHql(String hql, Object ... param) {
        Query q = this.getSession().createQuery(hql);
        if (param != null && param.length > 0) {
            int i = 0;
            while (i < param.length) {
                q.setParameter(i, param[i]);
                ++i;
            }
        }
        return q.list();
    }

    @Override
    public Integer executeHql(String hql) {
        Query q = this.getSession().createQuery(hql);
        return q.executeUpdate();
    }

    @Override
    public <T> List<T> pageList(DetachedCriteria dc, int firstResult, int maxResult) {
        Criteria criteria = dc.getExecutableCriteria(this.getSession());
        criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        criteria.setFirstResult(firstResult);
        criteria.setMaxResults(maxResult);
        return criteria.list();
    }

    @Override
    public <T> List<T> findByDetached(DetachedCriteria dc) {
        return dc.getExecutableCriteria(this.getSession()).list();
    }
}

