/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.common.dao.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.Query;
import org.jeecgframework.core.common.dao.ICommonDao;
import org.jeecgframework.core.common.dao.IGenericBaseCommonDao;
import org.jeecgframework.core.common.dao.impl.GenericBaseCommonDao;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.ImportFile;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.extend.swftools.SwfToolsUtil;
import org.jeecgframework.core.extend.template.DataSourceMap;
import org.jeecgframework.core.extend.template.Template;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.FileUtils;
import org.jeecgframework.core.util.GenericsUtils;
import org.jeecgframework.core.util.PasswordUtil;
import org.jeecgframework.core.util.PinyinUtil;
import org.jeecgframework.core.util.ReflectHelper;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.dao.JeecgDictDao;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.pojo.base.TSOperation;
import org.jeecgframework.web.system.pojo.base.TSRoleFunction;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import weixin.idea.video.common.FFMpegUtil;

@Repository
public class CommonDao
extends GenericBaseCommonDao
implements ICommonDao,
IGenericBaseCommonDao {
    @Autowired
    private JeecgDictDao jeecgDictDao;

    @Override
    public TSUser getUserByUserIdAndUserNameExits(TSUser user) {
        String password = PasswordUtil.encrypt(user.getUserName(), user.getPassword(), PasswordUtil.getStaticSalt());
        String userid = this.jeecgDictDao.queryUserByNameAndPassword(user.getUserName(), password);
        if (oConvertUtils.isNotEmpty(userid)) {
            TSUser u2 = this.get(TSUser.class, (Serializable)((Object)userid));
            return u2;
        }
        return null;
    }

    @Override
    public void pwdInit(TSUser user, String newPwd) {
        String query = "from TSUser u where u.userName = :username ";
        Query queryObject = this.getSession().createQuery(query);
        queryObject.setParameter("username", (Object)user.getUserName());
        List users = queryObject.list();
        if (users != null && users.size() > 0) {
            user = (TSUser)users.get(0);
            String pwd = PasswordUtil.encrypt(user.getUserName(), newPwd, PasswordUtil.getStaticSalt());
            user.setPassword(pwd);
            this.save(user);
        }
    }

    @Override
    public String getUserRole(TSUser user) {
        String userRole = "";
        List<TSRoleUser> sRoleUser = this.findByProperty(TSRoleUser.class, "TSUser.id", user.getId());
        for (TSRoleUser tsRoleUser : sRoleUser) {
            userRole = String.valueOf(userRole) + tsRoleUser.getTSRole().getRoleCode() + ",";
        }
        return userRole;
    }

    public Object uploadFile(UploadFile uploadFile) {
        Object object = uploadFile.getObject();
        if (uploadFile.getFileKey() != null) {
            this.updateEntitie(object);
        } else {
            try {
                String entityName;
                uploadFile.getMultipartRequest().setCharacterEncoding("UTF-8");
                MultipartHttpServletRequest multipartRequest = uploadFile.getMultipartRequest();
                ReflectHelper reflectHelper = new ReflectHelper(uploadFile.getObject());
                String uploadbasepath = uploadFile.getBasePath();
                if (uploadbasepath == null) {
                    uploadbasepath = ResourceUtil.getConfigByName("uploadpath");
                }
                Map fileMap = multipartRequest.getFileMap();
                String path = String.valueOf(uploadbasepath) + "/";
                String realPath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("/")) + "/" + path;
                File file = new File(realPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (uploadFile.getCusPath() != null) {
                    realPath = String.valueOf(realPath) + uploadFile.getCusPath() + "/";
                    path = String.valueOf(path) + uploadFile.getCusPath() + "/";
                    file = new File(realPath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                } else {
                    realPath = String.valueOf(realPath) + DataUtils.getDataString(DataUtils.yyyyMMdd) + "/";
                    path = String.valueOf(path) + DataUtils.getDataString(DataUtils.yyyyMMdd) + "/";
                    file = new File(realPath);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                }
                if ((entityName = uploadFile.getObject().getClass().getSimpleName()).equals("TSTemplate")) {
                    realPath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("/")) + ResourceUtil.getConfigByName("templatepath") + "/";
                    path = String.valueOf(ResourceUtil.getConfigByName("templatepath")) + "/";
                } else if (entityName.equals("TSIcon")) {
                    realPath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("/")) + uploadFile.getCusPath() + "/";
                    path = String.valueOf(uploadFile.getCusPath()) + "/";
                }
                String fileName = "";
                String swfName = "";
                for (Map.Entry entity : fileMap.entrySet()) {
                    MultipartFile mf = (MultipartFile)entity.getValue();
                    fileName = mf.getOriginalFilename();
                    swfName = PinyinUtil.getPinYinHeadChar(oConvertUtils.replaceBlank(FileUtils.getFilePrefix(fileName)));
                    String extend = FileUtils.getExtend(fileName);
                    String myfilename = "";
                    String noextfilename = "";
                    if (uploadFile.isRename()) {
                        noextfilename = String.valueOf(DataUtils.getDataString(DataUtils.yyyymmddhhmmss)) + StringUtil.random(8);
                        myfilename = String.valueOf(noextfilename) + "." + extend;
                    } else {
                        myfilename = fileName;
                    }
                    String savePath = String.valueOf(realPath) + myfilename;
                    String fileprefixName = FileUtils.getFilePrefix(fileName);
                    if (uploadFile.getTitleField() != null) {
                        reflectHelper.setMethodValue(uploadFile.getTitleField(), fileprefixName);
                    }
                    if (uploadFile.getExtend() != null) {
                        reflectHelper.setMethodValue(uploadFile.getExtend(), extend);
                    }
                    uploadFile.getByteField();
                    File savefile = new File(savePath);
                    if (uploadFile.getRealPath() != null) {
                        reflectHelper.setMethodValue(uploadFile.getRealPath(), String.valueOf(path) + myfilename);
                    }
                    this.saveOrUpdate(object);
                    FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
                    if (uploadFile.getSwfpath() != null) {
                        reflectHelper.setMethodValue(uploadFile.getSwfpath(), String.valueOf(path) + FileUtils.getFilePrefix(myfilename) + ".swf");
                        SwfToolsUtil.convert2SWF(savePath);
                    }
                    if (uploadFile.getSwfpath() == null || !entityName.equals("WeixinVideoEntity") && !entityName.equals("WeixinVideosucaiEntity")) continue;
                    reflectHelper.setMethodValue(uploadFile.getSwfpath(), String.valueOf(path) + FileUtils.getFilePrefix(myfilename) + ".flv");
                    String basePath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("/")) + ResourceUtil.getConfigByName("ffmpeg.dir");
                    FFMpegUtil ffMpegUtil = new FFMpegUtil(String.valueOf(basePath) + "ffmpeg", savePath);
                    ffMpegUtil.videoTransfer(String.valueOf(realPath) + FileUtils.getFilePrefix(myfilename) + ".flv", "640*480", 56, 22050, 10.0, 15.0);
                    ffMpegUtil.makeScreenCut(String.valueOf(realPath) + FileUtils.getFilePrefix(myfilename) + ".jpg", "640x480");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    @Override
    public HttpServletResponse viewOrDownloadFile(UploadFile uploadFile) {
        uploadFile.getResponse().setContentType("UTF-8");
        uploadFile.getResponse().setCharacterEncoding("UTF-8");
        InputStream bis = null;
        FilterOutputStream bos = null;
        HttpServletResponse response = uploadFile.getResponse();
        HttpServletRequest request = uploadFile.getRequest();
        String ctxPath = request.getSession().getServletContext().getRealPath("/");
        String downLoadPath = "";
        long fileLength = 0L;
        if (uploadFile.getRealPath() != null && uploadFile.getContent() == null) {
            downLoadPath = String.valueOf(ctxPath) + uploadFile.getRealPath();
            fileLength = new File(downLoadPath).length();
            try {
                bis = new BufferedInputStream(new FileInputStream(downLoadPath));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            if (uploadFile.getContent() != null) {
                bis = new ByteArrayInputStream(uploadFile.getContent());
            }
            fileLength = uploadFile.getContent().length;
        }
        try {
            try {
                int bytesRead;
                if (!uploadFile.isView() && uploadFile.getExtend() != null) {
                    if (uploadFile.getExtend().equals("text")) {
                        response.setContentType("text/plain;");
                    } else if (uploadFile.getExtend().equals("doc")) {
                        response.setContentType("application/msword;");
                    } else if (uploadFile.getExtend().equals("xls")) {
                        response.setContentType("application/ms-excel;");
                    } else if (uploadFile.getExtend().equals("pdf")) {
                        response.setContentType("application/pdf;");
                    } else if (uploadFile.getExtend().equals("jpg") || uploadFile.getExtend().equals("jpeg")) {
                        response.setContentType("image/jpeg;");
                    } else {
                        response.setContentType("application/x-msdownload;");
                    }
                    response.setHeader("Content-disposition", "attachment; filename=" + new String((String.valueOf(uploadFile.getTitleField()) + "." + uploadFile.getExtend()).getBytes("GBK"), "ISO8859-1"));
                    response.setHeader("Content-Length", String.valueOf(fileLength));
                }
                bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    @Override
    public Map<Object, Object> getDataSourceMap(Template template) {
        return DataSourceMap.getDataSourceMap();
    }

    @Override
    public HttpServletResponse createXml(ImportFile importFile) {
        HttpServletResponse response = importFile.getResponse();
        HttpServletRequest request = importFile.getRequest();
        try {
            Document document = DocumentHelper.createDocument();
            document.setXMLEncoding("UTF-8");
            String rootname = String.valueOf(importFile.getEntityName()) + "s";
            Element rElement = document.addElement(rootname);
            Class entityClass = importFile.getEntityClass();
            String[] fields = importFile.getField().split(",");
            List objList = this.loadAll(entityClass);
            Class<?> classType = entityClass.getClass();
            for (Object t : objList) {
                Element childElement = rElement.addElement(importFile.getEntityName());
                int i = 0;
                while (i < fields.length) {
                    String fieldName = fields[i];
                    if (i == 0) {
                        childElement.addAttribute(fieldName, String.valueOf(TagUtil.fieldNametoValues(fieldName, t)));
                    } else {
                        Element name = childElement.addElement(fieldName);
                        name.setText(String.valueOf(TagUtil.fieldNametoValues(fieldName, t)));
                    }
                    ++i;
                }
            }
            String ctxPath = request.getSession().getServletContext().getRealPath("");
            File fileWriter = new File(String.valueOf(ctxPath) + "/" + importFile.getFileName());
            XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(fileWriter));
            xmlWriter.write(document);
            xmlWriter.close();
            UploadFile uploadFile = new UploadFile(request, response);
            uploadFile.setRealPath(importFile.getFileName());
            uploadFile.setTitleField(importFile.getFileName());
            uploadFile.setExtend("bak");
            this.viewOrDownloadFile(uploadFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public void parserXml(String fileName) {
        try {
            File inputXml = new File(fileName);
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(inputXml);
            Element employees = document.getRootElement();
            Iterator i = employees.elementIterator();
            while (i.hasNext()) {
                Field[] fields;
                String id;
                Element employee = (Element)i.next();
                Class entityClass = GenericsUtils.getEntityClass(employee.getName());
                Object obj1 = this.getEntity(entityClass, (Serializable)((Object)(id = employee.attributeValue((fields = TagUtil.getFiled(entityClass))[0].getName()))));
                if (obj1 == null) {
                    obj1 = entityClass.newInstance();
                }
                Iterator j = employee.elementIterator();
                while (j.hasNext()) {
                    Element node = (Element)j.next();
                    int k = 0;
                    while (k < fields.length) {
                        if (node.getName().equals(fields[k].getName())) {
                            String fieldName = fields[k].getName();
                            String stringLetter = fieldName.substring(0, 1).toUpperCase();
                            String setName = "set" + stringLetter + fieldName.substring(1);
                            Method setMethod = entityClass.getMethod(setName, fields[k].getType());
                            String type = TagUtil.getColumnType(fieldName, fields);
                            if (type.equals("int")) {
                                setMethod.invoke(obj1, new Integer(node.getText()));
                            } else if (type.equals("string")) {
                                setMethod.invoke(obj1, node.getText().toString());
                            } else if (type.equals("short")) {
                                setMethod.invoke(obj1, new Short(node.getText()));
                            } else if (type.equals("double")) {
                                setMethod.invoke(obj1, new Double(node.getText()));
                            } else if (type.equals("Timestamp")) {
                                setMethod.invoke(obj1, new Timestamp(DataUtils.str2Date(node.getText(), DataUtils.datetimeFormat).getTime()));
                            }
                        }
                        ++k;
                    }
                }
                if (obj1 != null) {
                    this.saveOrUpdate(obj1);
                    continue;
                }
                this.save(obj1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<ComboTree> comTree(List<TSDepart> all, ComboTree comboTree) {
        ArrayList<ComboTree> trees = new ArrayList<ComboTree>();
        for (TSDepart depart : all) {
            trees.add(this.tree(depart, true));
        }
        return trees;
    }

    public ComboTree tree(TSDepart depart, boolean recursive) {
        ComboTree tree = new ComboTree();
        tree.setId(oConvertUtils.getString(depart.getId()));
        tree.setText(depart.getDepartname());
        List<TSDepart> departsList = this.findByProperty(TSDepart.class, "TSPDepart.id", depart.getId());
        if (departsList != null && departsList.size() > 0) {
            tree.setState("closed");
            tree.setChecked(false);
            if (recursive) {
                ArrayList<TSDepart> departList = new ArrayList<TSDepart>(departsList);
                ArrayList<ComboTree> children = new ArrayList<ComboTree>();
                for (TSDepart d : departList) {
                    ComboTree t = this.tree(d, true);
                    children.add(t);
                }
                tree.setChildren(children);
            }
        }
        return tree;
    }

    @Override
    public List<ComboTree> ComboTree(List all, ComboTreeModel comboTreeModel, List in) {
        ArrayList<ComboTree> trees = new ArrayList<ComboTree>();
        for (Object obj : all) {
            trees.add(this.comboTree(obj, comboTreeModel, in, false));
        }
        return trees;
    }

    private ComboTree comboTree(Object obj, ComboTreeModel comboTreeModel, List in, boolean recursive) {
        List tsFunctions;
        ComboTree tree = new ComboTree();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ReflectHelper reflectHelper = new ReflectHelper(obj);
        String id = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
        tree.setId(id);
        tree.setText(oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getTextField())));
        if (comboTreeModel.getSrcField() != null) {
            attributes.put("href", oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getSrcField())));
            tree.setAttributes(attributes);
        }
        if (in != null && in.size() > 0) {
            for (Object inobj : in) {
                ReflectHelper reflectHelper2 = new ReflectHelper(inobj);
                String inId = oConvertUtils.getString(reflectHelper2.getMethodValue(comboTreeModel.getIdField()));
                if (!inId.equals(id)) continue;
                tree.setChecked(true);
            }
        }
        if ((tsFunctions = (List)reflectHelper.getMethodValue(comboTreeModel.getChildField())) != null && tsFunctions.size() > 0) {
            tree.setState("closed");
            tree.setChecked(false);
        }
        return tree;
    }

    @Override
    public List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            List childList;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            String id = oConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getIdField()));
            String src = oConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getSrc()));
            String text = oConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getTextField()));
            if (StringUtils.isNotEmpty((String)treeGridModel.getOrder())) {
                String order = oConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            tg.setId(id);
            if (treeGridModel.getIcon() != null) {
                String iconpath = TagUtil.fieldNametoValues(treeGridModel.getIcon(), obj).toString();
                if (iconpath != null) {
                    tg.setCode(iconpath);
                } else {
                    tg.setCode("");
                }
            }
            tg.setSrc(src);
            tg.setText(text);
            if (treeGridModel.getParentId() != null) {
                Object pid = TagUtil.fieldNametoValues(treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getParentText() != null) {
                Object ptext = TagUtil.fieldNametoValues(treeGridModel.getTextField(), obj);
                if (ptext != null) {
                    tg.setParentText(ptext.toString());
                } else {
                    tg.setParentText("");
                }
            }
            if ((childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList())) != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getRoleid() != null) {
                String[] opStrings = new String[]{};
                List<TSRoleFunction> roleFunctions = this.findByProperty(TSRoleFunction.class, "TSFunction.id", id);
                if (roleFunctions.size() > 0) {
                    for (TSRoleFunction tRoleFunction : roleFunctions) {
                        String bbString;
                        TSRoleFunction roleFunction = tRoleFunction;
                        if (!roleFunction.getTSRole().getId().toString().equals(treeGridModel.getRoleid()) || (bbString = roleFunction.getOperation()) == null) continue;
                        opStrings = bbString.split(",");
                        break;
                    }
                }
                List<TSOperation> operateions = this.findByProperty(TSOperation.class, "TSFunction.id", id);
                StringBuffer attributes = new StringBuffer();
                if (operateions.size() > 0) {
                    for (TSOperation tOperation : operateions) {
                        if (opStrings.length < 1) {
                            attributes.append("<input type=checkbox name=operatons value=" + tOperation.getId() + "_" + id + ">" + tOperation.getOperationname());
                            continue;
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append("<input type=checkbox name=operatons");
                        int i = 0;
                        while (i < opStrings.length) {
                            if (opStrings[i].equals(tOperation.getId().toString())) {
                                sb.append(" checked=checked");
                            }
                            ++i;
                        }
                        sb.append(" value=" + tOperation.getId() + "_" + id + ">" + tOperation.getOperationname());
                        attributes.append(sb.toString());
                    }
                }
                tg.setOperations(attributes.toString());
            }
            treegrid.add(tg);
        }
        return treegrid;
    }
}

