/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.aop;

import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.springframework.stereotype.Component;

@Component
public class HiberAspect
extends EmptyInterceptor {
    private static final Logger logger = Logger.getLogger(HiberAspect.class);
    private static final long serialVersionUID = 1L;

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        TSUser currentUser = null;
        try {
            currentUser = ResourceUtil.getSessionUserName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (currentUser == null) {
            return true;
        }
        try {
            int index = 0;
            while (index < propertyNames.length) {
                if ("createDate".equals(propertyNames[index]) || "createDatetime".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = new Date();
                    }
                } else if ("createBy".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = currentUser.getId();
                    }
                } else if ("createKey".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = currentUser.getUserKey();
                    }
                } else if ("createName".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = currentUser.getUserName();
                    }
                } else if ("createRealname".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = currentUser.getRealName();
                    }
                } else if ("createDepartmentid".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = currentUser.getTSDepart().getId();
                    }
                } else if ("createDepartmentname".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = currentUser.getTSDepart().getDepartname();
                    }
                } else if ("accountid".equals(propertyNames[index])) {
                    if (oConvertUtils.isEmpty(state[index])) {
                        state[index] = ResourceUtil.getShangJiaAccountId();
                    }
                } else if ("postcode".equals(propertyNames[index]) && oConvertUtils.isEmpty(state[index])) {
                    state[index] = ResourceUtil.getShangJiaAccount().getPostCode();
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        TSUser currentUser = null;
        try {
            currentUser = ResourceUtil.getSessionUserName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (currentUser == null) {
            return true;
        }
        int index = 0;
        while (index < propertyNames.length) {
            if ("updateDate".equals(propertyNames[index]) || "updateDatetime".equals(propertyNames[index])) {
                currentState[index] = new Date();
            } else if ("updateBy".equals(propertyNames[index])) {
                currentState[index] = currentUser.getId();
            } else if ("updateName".equals(propertyNames[index])) {
                currentState[index] = currentUser.getUserName();
            } else if ("updateRealname".equals(propertyNames[index])) {
                currentState[index] = currentUser.getRealName();
            } else if ("updateDepartmentid".equals(propertyNames[index])) {
                currentState[index] = currentUser.getTSDepart().getId();
            } else if ("updateDepartmentname".equals(propertyNames[index])) {
                currentState[index] = currentUser.getTSDepart().getDepartname();
            }
            ++index;
        }
        return true;
    }
}

