<#--noinspection HtmlUnknownTarget,FtlReferencesInspection-->
<#include "ftl/common.ftl">
<#assign baseLib="${base}/desform/lib">
<#assign baseJmForm="${baseLib}/jm-form">
<#assign baseElementUI="${baseLib}/element-ui">
<!DOCTYPE html>
<html lang="zh-Hans">

<head>
	<title></title>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=Edge，chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
	<#-- 加载样式 -->
	<link rel="stylesheet" href="${baseElementUI}/elementUI.css?${CACHE_VERSION}">
	<link rel="stylesheet" href="${baseJmForm}/JmForm.css?${CACHE_VERSION}">
	<style>
		html,
		body,
		#app {
			height: 100%;
		}
	</style>
</head>

<body>
	<div id="app">
		<!-- 需要设置编辑区域高度 -->
		<!-- preview upload generate-code generate-json -->
		<!-- :base-url="baseURL" :access-token="token" -->
		<jm-design-form ref="jmform" :debug="debug" style="height: 100%" >
			<template slot="action">
				<el-button type="text" size="medium" icon="el-icon-view" @click="handlePreview">预览</el-button>
				<el-button type="text" size="medium" icon="el-icon-document-checked" @click="handleSaveForm">保存</el-button>
				<el-button type="text" size="medium" icon="el-icon-close" style="color:red" @click="handleClose">关闭</el-button>
			</template>
		</jm-design-form>

	</div>
</body>

<script src="${base}/desform/lib/unpkg/polyfill/7.2.5/polyfill.js"></script>

<script src="${base}/desform/lib/unpkg/vue@2.6.10/vue.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/lib/unpkg/jquery@3.4.1/jquery.js?${CACHE_VERSION}"></script>
<script src="${baseElementUI}/ElementUI.umd.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/lib/unpkg/vue-ls@3.2.1/vue-ls.min.js?${CACHE_VERSION}"></script>
<!-- 引入组件库 -->
<script src="${baseJmForm}/JmForm.umd.js?${CACHE_VERSION}"></script>
<!-- 需要在设计器中预览代码需要引入ace.js库 -->
<script src="${base}/desform/lib/unpkg/jm-form@1.1.23/ace.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/utils.js?${CACHE_VERSION}"></script>

<script src="${base}/desform/lib/qrcode.min.js?${CACHE_VERSION}"></script>

<script>

	var store = JmForm.default.store
	var DeviceMixins = JmForm.default.mixins.DeviceMixins
	var constant = JmForm.default.constant

	// 从配置里读取主题颜色
	window['THEME_COLOR'] = '${themeColor}'
	// 从配置里读取上传方式
	window['UPLOAD_TYPE'] = '${uploadType}'

	var debug = getQueryParams("debug")
  debug = !(debug === 'false')

  // 暂时关闭 debug 模式
  debug = true

	var token = getQueryParams("token")
	var messageId = getQueryParams("messageId")

	Vue.ls.set(constant.BASE_URL, '${baseURL}')
	Vue.ls.set(constant.ACCESS_TOKEN, token)

	<#if desform ? exists>
	window.desformId = '${desform.id}'
	window.desformCode = '${desform.desformCode}'
	window.desformName = '${desform.desformName}'
	</#if>

	<#if qiniuConfig ? exists>
	console.log('qiniuConfig: ', ${qiniuConfig})
	window.qiniuConfig = ${qiniuConfig}
	</#if>



	new Vue({
		el: '#app',
		store: store,
		mixins: [DeviceMixins],
		data: {

			<#if onlineCgformOptions ? exists>
			onlineFormOptions: ${onlineCgformOptions},
			</#if>
			<#if sysDictOptions ? exists>
			sysDictOptions: ${sysDictOptions},
			</#if>

      debug: debug,
			token: token,
			baseURL: '${baseURL}'
		},
		created: function () {
			var _this = this
			window.addEventListener('message', function (event) {
				// let { messageId, type, data } = event.data // 这里尽量不要使用 ES6 写法
				// switch (type) {
				// 	case '':
				// 		break
				// }
			}, false)
			postEvent('created', null, messageId)
		},
		mounted: function () {
			//-- <#if designJson ? exists>
			this.setJSON(${designJson})
			//-- </#if>



		},
		methods: {

			/** 点击保存按钮事件 */
			handleSaveForm: function () {
				var _this = this
				var source = _this.getjson()
				if (source.list.length === 0) {
					_this.postModal('alert-warning', '无法保存空表单', "提示")
					return
				}
				postEvent('request-save', JSON.stringify(source), messageId)
			},

			/** 点击关闭按钮事件 */
			handleClose: function () {
				postEvent('closing', this.getjson(), messageId)
			},

			/** 点击浏览按钮 */
			handlePreview: function () {
				this.$refs.jmform.handlePreview()
			},

			/** 获取设计器json数据 **/
			getjson: function () {
				return this.$refs.jmform.getJSON()
			},
			/** 设置设计器json数据 **/
			setJSON: function (json) {
				this.$refs.jmform.setJSON(json);
			},

			/** 向父级提出弹窗申请 */
			postModal: function (type, content, title, options) {
				postEvent('modal', {
					type: type,
					title: title,
					content: content,
					options: options
				}, messageId)
			},

		}
	})
</script>

</html>