/** 获取url中的参数 */
function getQueryParams(paramName) {
    var query = window.location.search.substring(1);
    var params = query.split("&");
    for (var i in params) {
        var param = params[i].split("=");
        if (param[0] == paramName) {
            return param[1];
        }
    }
    return null;
}

/** 通用向父级发送message */
function postEvent(type, data, messageId) {
    if (data == null) data = {}
    // 向父级发送message（如果有）
    if (window['parent'] && window['parent'].postMessage) {
        window['parent'].postMessage({
            type: type,
            data: data,
            messageId: messageId
        }, '*')
    }
    // 兼容uni
    if (window['uni']) {
        if (window['uni'].postMessage) {
            window['uni'].postMessage({
                type: type,
                data: data,
                messageId: messageId
            }, '*')
        }
        // 成功之后调用 navigateBack 返回
        if (type === 'save' && window['uni'].navigateBack) {
            window['uni'].navigateBack({
                delta: 0
            })
        }
    }
}

/** 通用发起请求 */
function request(options) {

    $.ajax({
        url: options.url,
        method: options.method,
        data: (function () {
            if (options.method === "GET") {
                return options.data;
            } else if (options.data == null) {
                return "{}"
            } else if (typeof options.data === 'string') {
                return options.data;
            } else {
                return JSON.stringify(options.data)
            }
        })(),
        beforeSend: function (request) {
            request.setRequestHeader("X-Access-Token", options.token)
            request.setRequestHeader("Content-type", "application/json;charset=UTF-8")
        },
        success: function (res) {
            if (typeof options.success === 'function') {
                options.success(res)
            } else {
                console.log('res:', res)
            }
        },
        error: function (res) {
            if (typeof options.fail === 'function') {
                options.fail(res)
            } else {
                console.error('res:', res)
            }
        }
    })
}

/** 通用封装options */
function packageOptions(source, labelName, valueName) {
    var options = []
    for (var i in source) {
        options.push({
            label: source[i][labelName],
            value: source[i][valueName]
        })
    }
    return options
}

/**
 * 两个对象合并
 * @param target
 * @param source...
 */
function objectAssign() {
    var target = arguments[0]
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
            if (source.hasOwnProperty(key)) {
                target[key] = source[key];
            }
        }
    }
    return target
}

var BrowserTypes = {
  isWeChat: function () {
    var ua = navigator.userAgent.toLowerCase()
    return ua.indexOf('micromessenger') !== -1
  }
}