/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.CommonRandomUtil;
import org.apache.commons.lang.StringUtil;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.filter.es;
import org.springframework.web.filter.w;

public class ResouceEncodingFilter
implements Filter {
    private static final String STATIC_SOURCE_ROOT = "/";
    private static final String DIAN = ".";
    private static final String NO_FILTER_ACTION = ".do";
    private static final String NO_FILTER_JSP = ".jsp";
    private static final String STATIC_TEMPLATE_SOURCE = "online/template";
    private static final String STATIC_TEMPLATE_SOURCE_2 = "clzcontext/template";
    private static final String STATIC_TEMPLATE_SOURCE_3 = "/content/";
    private static final String STATIC_TEMPLATE_SOURCE_4 = "/plug-in-ui/";
    private static final String STATIC_TEMPLATE_SOURCE_5 = "/plug-in/designer/";
    private static final String STATIC_TEMPLATE_SOURCE_6 = "/template/";
    private static final String STATIC_TEMPLATE_SOURCE_7 = "/plug-in/Formdesign/";
    private static List<String> SCAN_SOURCES;
    private static boolean SCAN_FLAG;

    static {
        SCAN_FLAG = CommonRandomUtil.TRUE;
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        String scanPackages = config.getInitParameter("scans");
        String[] scan_packages = null;
        if (StringUtil.isNotBlank(scanPackages)) {
            scan_packages = scanPackages.split(",");
        }
        if (scan_packages != null && scan_packages.length > 0) {
            SCAN_SOURCES = new ArrayList<String>();
            SCAN_SOURCES = new ArrayList<String>(Arrays.asList(scan_packages));
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_6);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_4);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_3);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_2);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE);
        } else {
            SCAN_SOURCES = new ArrayList<String>();
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_6);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_4);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_3);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_2);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_7);
            SCAN_SOURCES.add(STATIC_TEMPLATE_SOURCE_5);
        }
    }

    private byte[] gzip(byte[] data) {
        ByteArrayOutputStream byteOutput;
        block13: {
            byteOutput = new ByteArrayOutputStream(10240);
            DeflaterOutputStream output = null;
            try {
                try {
                    output = new GZIPOutputStream(byteOutput);
                    output.write(data);
                }
                catch (IOException localIOException) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byteOutput.toByteArray();
    }

    private static boolean isGZipEncoding(HttpServletRequest request) {
        boolean flag = false;
        String encoding = request.getHeader("Accept-Encoding");
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            flag = true;
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest req = (HttpServletRequest)request;
        String url = req.getRequestURI();
        if (url.indexOf(NO_FILTER_ACTION) == -1 && url.indexOf(DIAN) != -1 && url.toLowerCase().indexOf(NO_FILTER_JSP) == -1 && CommonRandomUtil.indexofArray(url, SCAN_SOURCES)) {
            url = url.replaceFirst(req.getContextPath(), "");
            response.reset();
            String s = es.get(url.substring(url.lastIndexOf(DIAN)).replace(DIAN, ""));
            if (s != null) {
                response.setContentType(s);
            }
            OutputStream os = null;
            InputStream is = null;
            try {
                try {
                    url = url.replaceFirst(req.getContextPath(), "");
                    is = this.getClass().getResourceAsStream(url);
                    if (is != null) {
                        this.cacheResource(request, (ServletResponse)response, chain);
                        os = response.getOutputStream();
                        FileCopyUtils.copy((InputStream)is, (OutputStream)os);
                        return;
                    }
                    chain.doFilter(request, (ServletResponse)response);
                    return;
                }
                catch (IOException localIOException2) {
                    block38: {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (is == null) {
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (is == null) return;
                            try {
                                is.close();
                                return;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (os == null) break block38;
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (is == null) return;
                    try {
                        is.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (url.indexOf("ReportServer") != -1) {
            chain.doFilter(request, (ServletResponse)response);
            return;
        } else if (ResouceEncodingFilter.isGZipEncoding(req)) {
            w wrapper = new w(response);
            chain.doFilter(request, (ServletResponse)wrapper);
            byte[] gzipData = this.gzip(wrapper.getResponseData());
            response.addHeader("Content-Encoding", "gzip");
            response.setContentLength(gzipData.length);
            ServletOutputStream output = response.getOutputStream();
            output.write(gzipData);
            output.flush();
            return;
        } else {
            chain.doFilter(request, (ServletResponse)response);
        }
    }

    public void cacheResource(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        uri = uri.substring(uri.lastIndexOf(DIAN) + 1);
        long date = 0L;
        if (uri.equalsIgnoreCase("jpg")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        if (uri.equalsIgnoreCase("gif")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        if (uri.equalsIgnoreCase("css")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        if (uri.equalsIgnoreCase("js")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        res.setDateHeader("Expires", date);
    }
}

