/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

class LOCALMAC {
    LOCALMAC() {
    }

    public static void main(String[] args) throws UnknownHostException, SocketException {
        System.out.println("\u672c\u673aMAC\u5730\u5740:" + LOCALMAC.getMacAddress());
    }

    private static String getLocalMacByIp() {
        String returnMac = "";
        byte[] mac = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        }
        catch (Exception e) {
            return null;
        }
        StringBuffer sb = new StringBuffer("");
        if (mac == null) {
            return null;
        }
        int i = 0;
        while (i < mac.length) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
            } else {
                sb.append(str);
            }
            ++i;
        }
        returnMac = sb.toString().toUpperCase();
        if ("".equals(returnMac)) {
            return null;
        }
        return returnMac;
    }

    private static String getUnixMACAddress() {
        String mac_s = "";
        try {
            Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
            while (el.hasMoreElements()) {
                byte[] mac = el.nextElement().getHardwareAddress();
                if (mac == null) continue;
                StringBuilder builder = new StringBuilder();
                byte[] byArray = mac;
                int n = mac.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    builder.append(LOCALMAC.hexByte(b));
                    builder.append("-");
                    ++n2;
                }
                builder.deleteCharAt(builder.length() - 1);
                mac_s = builder.toString().toUpperCase();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mac_s;
    }

    private static String hexByte(byte b) {
        String s = "000000" + Integer.toHexString(b);
        return s.substring(s.length() - 2);
    }

    private static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getMacAddress() {
        String os = LOCALMAC.getOSName();
        String mac = null;
        mac = os.startsWith("windows") ? LOCALMAC.getLocalMacByIp() : LOCALMAC.getUnixMACAddress();
        return mac;
    }
}

