/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.SerializedLambda;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtil;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLowApp;
import org.jeecg.common.constant.enums.LowAppAopEnum;
import org.jeecg.common.es.JeecgElasticsearchTemplate;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.model.LowAppCopyMenu;
import org.jeecg.common.lowapp.utils.LowAppCopyUtil;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.dynamic.db.DbTypeUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.constant.a;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormAuth;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mapper.DesignFormDataMapper;
import org.jeecg.modules.online.desform.mapper.DesignFormMapper;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormSettingService;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.jeecg.modules.online.desform.service.impl.b;
import org.jeecg.modules.online.desform.util.f;
import org.jeecg.modules.online.desform.vo.DesignFormViewVo;
import org.jeecg.modules.online.desform.vo.excel.DesformWidgetList;
import org.jeecg.modules.online.desform.vo.query.IdOrCodeParam;
import org.jeecg.modules.online.desform.vo.widget.DesformOptions;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.ModelAndView;

@Service(value="designFormServiceImpl")
public class g
extends ServiceImpl<DesignFormMapper, DesignForm>
implements IDesignFormService {
    private static final Logger a = LoggerFactory.getLogger(g.class);
    @Autowired
    private DesignFormMapper designFormMapper;
    @Autowired
    private ISysBaseAPI sysBaseApi;
    @Autowired
    private IDesignFormDataService designFormDataService;
    @Autowired
    private DesignFormDataMapper designFormDataMapper;
    @Autowired
    private b designFormAuthService;
    @Lazy
    @Autowired
    private IOnlineBaseExtApi onlineBaseExtApi;
    @Autowired
    private JeecgElasticsearchTemplate jes;
    @Autowired
    public RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IDesignFormListViewService designFormListViewService;
    @Autowired
    private IDesignFormSettingService designFormSettingService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(DesignForm designForm) {
        int n2;
        if (designForm.getUpdateCount() == null) {
            designForm.setUpdateCount(0);
        }
        if (oConvertUtils.isEmpty((Object)designForm.getDesformType())) {
            designForm.setDesformType(org.jeecg.modules.online.desform.constant.a.c);
        }
        if ((n2 = this.designFormMapper.insert(designForm)) > 0 && oConvertUtils.isNotEmpty((Object)designForm.getDesformDesignJson())) {
            ArrayList arrayList = new ArrayList();
            f.a(designForm, (widgetTypes, jSONObject, jSONObject2) -> {
                if (jSONObject.getBooleanValue("isContainer")) {
                    return;
                }
                DesignFormAuth designFormAuth = new DesignFormAuth();
                designFormAuth.setDesformId(designForm.getId());
                designFormAuth.setDesformCode(designForm.getDesformCode());
                designFormAuth.setAuthTitle(jSONObject.getString("name"));
                designFormAuth.setAuthComKey(jSONObject.getString("key"));
                designFormAuth.setAuthField(jSONObject.getString("model"));
                designFormAuth.setStatus(org.jeecg.modules.online.desform.constant.a.h);
                boolean bl = jSONObject2 != null && jSONObject2.getString("type").equals(WidgetTypes.SUB_TABLE_DESIGN.getType());
                designFormAuth.setSubTable(bl);
                arrayList.addAll(this.designFormAuthService.parseAuths(designFormAuth));
            });
            if (arrayList.size() > 0) {
                this.designFormAuthService.saveBatch(arrayList);
            }
        }
        this.designFormListViewService.createBaseView(designForm.getDesformCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        DesignForm designForm = (DesignForm)((DesignFormMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (designForm != null) {
            this.designFormDataService.removeByCode(designForm.getDesformCode());
            this.designFormMapper.deleteById((Serializable)((Object)designForm.getId()));
            this.designFormAuthService.removeByCode(designForm.getDesformCode());
            this.designFormListViewService.deleteFormViewData(designForm.getDesformCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delBatchMain(Collection<? extends Serializable> idList) {
        List list = ((DesignFormMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().in(DesignForm::getId, idList));
        for (DesignForm designForm : list) {
            this.designFormDataService.removeByCode(designForm.getDesformCode());
            this.designFormMapper.deleteById((Serializable)((Object)designForm.getId()));
            this.designFormAuthService.removeByCode(designForm.getDesformCode());
            this.deleteRedisCache(designForm.getDesformCode());
            this.designFormListViewService.deleteFormViewData(designForm.getDesformCode());
        }
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode")
    public DesignForm getByCode(String desformCode) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DesignForm::getDesformCode, (Object)desformCode);
        DesignForm designForm = (DesignForm)((DesignFormMapper)this.baseMapper).selectOne((Wrapper)lambdaQueryWrapper);
        return designForm;
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformId")
    public DesignForm getByIdCache(String desformId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DesignForm::getId, (Object)desformId);
        return (DesignForm)((DesignFormMapper)this.baseMapper).selectOne((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public DesignForm getByIdOrCode(@NotNull IdOrCodeParam param) {
        if (param.isId()) {
            return this.getByIdCache(param.getId());
        }
        if (param.isCode()) {
            return this.getByCode(param.getCode());
        }
        throw new JeecgBootException("\u53c2\u6570\u9519\u8bef\uff0cid\u548ccode\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:code2id"}, key="#desformCode", unless="#result == null")
    public String getIdByCode(String desformCode) {
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm != null) {
            return designForm.getId();
        }
        return null;
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:id2code"}, key="#desformId", unless="#result == null")
    public String getCodeById(String desformId) {
        DesignForm designForm = this.getByIdCache(desformId);
        if (designForm != null) {
            return designForm.getDesformCode();
        }
        return null;
    }

    @Override
    public ModelAndView queryFormViewData(DesignForm designForm, String dataId, String onlineDataId, ModelAndView modelAndView) {
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u4e0d\u5b58\u5728\uff01");
        }
        modelAndView.addObject("designForm", (Object)this.queryAllDictItem(designForm));
        String string = designForm.getDesformCode();
        if (org.jeecg.modules.online.desform.constant.a.d.equals(designForm.getDesformType())) {
            string = designForm.getParentCode();
        }
        modelAndView.addObject("queryDesformCode", (Object)string);
        String string2 = "add";
        if (!string2.equals(dataId)) {
            String string3;
            DesignFormData designFormData = null;
            if (StringUtil.isNotEmpty((String)onlineDataId)) {
                JSONObject jSONObject;
                Object object;
                JSONObject jSONObject2;
                Object object2;
                string3 = null;
                String string4 = designForm.getDesformDesignJson();
                if (oConvertUtils.isNotEmpty((Object)string4) && (object2 = (jSONObject2 = JSONObject.parseObject((String)string4)).get((Object)"config")) != null && (object = (jSONObject = (JSONObject)object2).get((Object)"onlineForm")) != null) {
                    string3 = (String)object;
                }
                if (StringUtil.isNotEmpty(string3)) {
                    Object object3;
                    Object object4;
                    designFormData = new DesignFormData();
                    jSONObject2 = this.onlineBaseExtApi.cgformQueryAllDataByTableName(string3, onlineDataId);
                    if (jSONObject2 == null) {
                        throw new JeecgBootException("\u8868\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff01");
                    }
                    object2 = jSONObject2.getJSONObject("main");
                    jSONObject = jSONObject2.getJSONObject("one2one");
                    object = jSONObject2.getJSONObject("one2many");
                    if (jSONObject != null) {
                        for (String string5 : jSONObject.keySet()) {
                            object4 = jSONObject.getJSONObject(string5);
                            for (String string6 : object4.keySet()) {
                                object2.put(string5 + "#" + string6, object4.get((Object)string6));
                            }
                        }
                    }
                    if (object != null) {
                        for (String string5 : object.keySet()) {
                            object4 = null;
                            try {
                                object4 = URLEncoder.encode(object.getJSONArray(string5).toJSONString(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                            }
                            object2.put("sub-table-design_" + string5, object4);
                        }
                    }
                    try {
                        object3 = CommonUtils.getDatabaseTypeEnum();
                        if (DbTypeUtils.dbTypeIsOracle((DbType)object3)) {
                            designFormData.setDesformDataJson(JSONObject.toJSONString(org.jeecg.modules.online.desform.util.g.a((Map<String, Object>)object2)));
                        } else {
                            designFormData.setDesformDataJson(JSONObject.toJSONString((Object)object2));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        designFormData.setDesformDataJson(JSONObject.toJSONString((Object)object2));
                    }
                    designFormData.setDesformId(designForm.getId());
                    designFormData.setDesformCode(designForm.getDesformCode());
                    designFormData.setDesformName(designForm.getDesformName());
                    designFormData.setOnlineFormCode(string3);
                    designFormData.setOnlineFormDataId(onlineDataId);
                    object3 = this.designFormDataService.getByOnlineDataId(string, onlineDataId);
                    if (object3 != null) {
                        designFormData.setId(((DesignFormData)object3).getId());
                    } else {
                        designFormData.setId("ONLINE-DATA-TEMP-ID");
                    }
                }
            } else {
                designFormData = this.designFormDataService.getById(string, dataId);
            }
            if (designFormData == null) {
                throw new JeecgBootException("\u8868\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0cdataId=" + dataId);
            }
            modelAndView.addObject("designFormData", (Object)designFormData);
            if (designFormData != null) {
                a.debug(" designFormData: " + designFormData.toString());
                string3 = this.designFormDataService.translateData(designForm, designFormData);
                modelAndView.addObject("translData", (Object)JSON.toJSONString((Object)string3, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
        }
        this.updateHasWidgets(designForm.getDesformDesignJson(), modelAndView);
        return modelAndView;
    }

    @Override
    public ModelAndView queryFormViewById(String desformId, String dataId, String onlineDataId, ModelAndView modelAndView) {
        DesignForm designForm = (DesignForm)this.getById((Serializable)((Object)desformId));
        return this.queryFormViewData(designForm, dataId, onlineDataId, modelAndView);
    }

    @Override
    public ModelAndView queryFormViewByCode(IdOrCodeParam idOrCode, String dataId, String onlineDataId, ModelAndView modelAndView) {
        return this.queryFormViewByCode(idOrCode, dataId, onlineDataId, false, modelAndView);
    }

    @Override
    public ModelAndView queryFormAutoViewByCode(String desformCode, String dataId, String onlineDataId, ModelAndView modelAndView) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DesignForm::getParentCode, (Object)desformCode);
        lambdaQueryWrapper.eq(DesignForm::getIzMobileView, (Object)org.jeecg.modules.online.desform.constant.a.a);
        List list = super.list((Wrapper)lambdaQueryWrapper);
        DesignForm designForm = null;
        designForm = list.size() > 0 ? (DesignForm)list.get(0) : this.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u4e0d\u5b58\u5728\uff01");
        }
        return this.queryFormViewData(designForm, dataId, onlineDataId, modelAndView);
    }

    @Override
    public ModelAndView queryFormViewByCode(IdOrCodeParam idOrCode, String dataId, String onlineDataId, boolean isExternal, ModelAndView modelAndView) {
        DesignForm designForm = this.getByIdOrCode(idOrCode);
        if (designForm != null && isExternal) {
            JSONObject jSONObject = JSON.parseObject((String)designForm.getDesformDesignJson());
            JSONObject jSONObject2 = jSONObject.getJSONObject("config");
            boolean bl = jSONObject2.getBooleanValue("allowExternalLink");
            if (!bl) {
                throw new JeecgBootException("\u5df2\u7981\u6b62\u8bbf\u95ee\u6b64\u94fe\u63a5");
            }
            Boolean bl2 = jSONObject2.getBoolean("externalLinkShowData");
            modelAndView.addObject("showSaveData", (Object)(bl2 == null || bl2 != false ? 1 : 0));
            String string = jSONObject2.getString("externalTitle");
            if (oConvertUtils.isEmpty((Object)string)) {
                string = designForm.getDesformName();
            }
            modelAndView.addObject("externalTitle", (Object)string);
            String string2 = jSONObject2.getString("headerImgUrl");
            boolean bl3 = false;
            if (oConvertUtils.isNotEmpty((Object)string2)) {
                bl3 = true;
                modelAndView.addObject("headerImgUrl", (Object)f.b(string2));
            }
            modelAndView.addObject("showHeaderImg", (Object)bl3);
        }
        return this.queryFormViewData(designForm, dataId, onlineDataId, modelAndView);
    }

    @Override
    public void updateHasWidgets(String designJson, ModelAndView modelAndView) {
        if (designJson == null) {
            return;
        }
        JSONObject jSONObject3 = JSON.parseObject((String)designJson);
        JSONObject jSONObject4 = jSONObject3.getJSONObject("config");
        JSONArray jSONArray = null;
        if (jSONObject4 != null) {
            jSONArray = jSONObject4.getJSONArray("hasWidgets");
        }
        if (jSONArray == null) {
            JSONArray jSONArray2 = new JSONArray();
            f.a(jSONObject3.getJSONArray("list"), (widgetTypes, jSONObject, jSONObject2) -> {
                if (!jSONArray2.contains((Object)widgetTypes.getType())) {
                    jSONArray2.add((Object)widgetTypes.getType());
                }
            });
            jSONArray = jSONArray2;
        }
        boolean bl = jSONArray.contains((Object)WidgetTypes.MAP.getType());
        boolean bl2 = jSONArray.contains((Object)WidgetTypes.LOCATION.getType());
        modelAndView.addObject("hasMap", (Object)(bl || bl2 ? 1 : 0));
    }

    @Override
    public DesignForm queryAllDictItem(DesignForm designForm) {
        String string = designForm.getDesformDesignJson();
        if (StringUtil.isEmpty((String)string)) {
            return designForm;
        }
        JSONObject jSONObject = JSONObject.parseObject((String)string, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray jSONArray = jSONObject.getJSONArray("list");
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
            String string2 = jSONObject2.getString("type");
            if ("grid".equals(string2) || "sub-table-design".equals(string2)) {
                JSONArray jSONArray2 = jSONObject2.getJSONArray("columns");
                for (int i3 = 0; i3 < jSONArray2.size(); ++i3) {
                    JSONArray jSONArray3 = jSONArray2.getJSONObject(i3).getJSONArray("list");
                    for (int i4 = 0; i4 < jSONArray3.size(); ++i4) {
                        this.a(jSONArray3.getJSONObject(i4));
                    }
                }
                continue;
            }
            this.a(jSONObject2);
        }
        designForm.setDesformDesignJson(JSON.toJSONString((Object)jSONObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return designForm;
    }

    private void a(JSONObject jSONObject) {
        JSONArray jSONArray;
        String string = jSONObject.getString("type");
        if (WidgetTypes.SELECT.getType().equals(string) && (jSONArray = this.b(jSONObject)) != null) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("options");
            jSONObject2.put("remote", (Object)false);
            jSONObject2.put("showLabel", (Object)true);
            jSONObject2.put("options", (Object)jSONArray);
        }
    }

    private JSONArray b(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("options");
            String string = jSONObject2.getString("remote");
            if ("dict".equals(string)) {
                String string2 = jSONObject2.getString("dictCode");
                List list = oConvertUtils.isNotEmpty((Object)string2) ? this.sysBaseApi.queryDictItemsByCode(string2) : new ArrayList();
                JSONArray jSONArray = new JSONArray();
                for (DictModel dictModel : list) {
                    JSONObject jSONObject3 = new JSONObject();
                    jSONObject3.put("label", (Object)dictModel.getText());
                    jSONObject3.put("value", (Object)dictModel.getValue());
                    jSONArray.add((Object)jSONObject3);
                }
                return jSONArray;
            }
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Result redoAllIndex(String rowIds, Integer pageSize, boolean batchSave) {
        if (pageSize == null) {
            return this.a(rowIds, null, null, batchSave);
        }
        return this.a(rowIds, 1, pageSize, batchSave);
    }

    private Result a(String string2, Integer n2, Integer n3, boolean bl) {
        try {
            Object object2;
            List list;
            if (this.designFormDataService instanceof org.jeecg.modules.online.desform.mongo.service.a.b) {
                throw new JeecgBootException("MongoDB \u4e0b\u65e0\u9700\u91cd\u7f6e\u7d22\u5f15");
            }
            long l2 = System.currentTimeMillis();
            a.info("-- \u5df2\u5f00\u59cb\u5feb\u901f\u91cd\u7f6eES\u7d22\u5f15\u6570\u636e");
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            if (oConvertUtils.isNotEmpty((Object)string2)) {
                lambdaQueryWrapper.in(DesignFormData::getDesformId, Arrays.asList(string2.split(",")));
            }
            Page page = null;
            if (n2 == null || n3 == null) {
                list = this.designFormDataMapper.selectList((Wrapper)lambdaQueryWrapper);
            } else {
                bl = true;
                page = (Page)this.designFormDataMapper.selectPage((IPage)new Page((long)n2.intValue(), (long)n3.intValue()), (Wrapper)lambdaQueryWrapper);
                list = page.getRecords();
                a.info("-- \u5feb\u901f\u5206\u9875\u91cd\u7f6e\uff1a\uff08\u7b2c " + page.getCurrent() + " \u9875/\u5171 " + page.getPages() + " \u9875\uff09");
            }
            HashMap<String, DesformWidgetList> hashMap = new HashMap<String, DesformWidgetList>(10);
            int n4 = 0;
            int n5 = 0;
            if (!bl) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    DesignFormData designFormData = (DesignFormData)list.get(i2);
                    object2 = designFormData.getDesformCode();
                    a.info("---- \u6b63\u5728\u91cd\u7f6e\uff1a" + (String)object2 + "\uff08\u7b2c " + (i2 + 1) + " \u4e2a/\u5171 " + list.size() + " \u4e2a\uff09");
                    JSONObject jSONObject = JSON.parseObject((String)designFormData.getDesformDataJson());
                    this.a((String)object2, hashMap, jSONObject);
                    org.jeecg.modules.online.desform.es.b.a.a((DesformWidgetList)hashMap.get(object2), jSONObject);
                    if (this.jes.saveOrUpdate((String)object2, "design_form", designFormData.getId(), jSONObject)) {
                        ++n4;
                        continue;
                    }
                    ++n5;
                }
            } else {
                JSONArray jSONArray;
                String string3;
                HashMap<String, JSONArray> hashMap2 = new HashMap<String, JSONArray>(10);
                for (Object object2 : list) {
                    string3 = ((DesignFormData)object2).getDesformCode();
                    JSONObject jSONObject = JSON.parseObject((String)((DesignFormData)object2).getDesformDataJson());
                    jSONObject.put("id", (Object)((DesignFormData)object2).getId());
                    jSONArray = hashMap2.computeIfAbsent(string3, string -> new JSONArray());
                    jSONArray.add((Object)jSONObject);
                }
                for (Object object2 : hashMap2.keySet()) {
                    string3 = (JSONArray)hashMap2.get(object2);
                    for (int i3 = 0; i3 < string3.size(); ++i3) {
                        jSONArray = string3.getJSONObject(i3);
                        this.a((String)object2, hashMap, (JSONObject)jSONArray);
                        org.jeecg.modules.online.desform.es.b.a.a((DesformWidgetList)hashMap.get(object2), (JSONObject)jSONArray);
                    }
                    a.info("---- \u6b63\u5728\u6279\u91cf\u91cd\u7f6e\uff1a" + (String)object2 + "\uff08\u5171 " + string3.size() + " \u6761\u6570\u636e\uff09");
                    this.jes.saveBatch((String)object2, "design_form", (JSONArray)string3);
                }
            }
            long l3 = System.currentTimeMillis();
            object2 = n5 == 0 ? "\u5feb\u901f\u91cd\u7f6eES\u7d22\u5f15\u5168\u90e8\u6210\u529f!" : String.format("\u5feb\u901f\u91cd\u7f6eES\u7d22\u5f15\uff1a\u6210\u529f\u4e86%s\u6761\uff0c\u5931\u8d25\u4e86%s\u6761", n4, n5);
            a.info("-- " + (String)object2);
            a.info("-- \u603b\u8017\u65f6\uff1a" + (l3 - l2) + " ms");
            if (page != null && page.hasNext()) {
                n2 = n2 + 1;
                return this.a(string2, n2, n3, bl);
            }
            return Result.ok();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Result.error((String)exception.getMessage());
        }
    }

    private void a(String string, Map<String, DesformWidgetList> map, JSONObject jSONObject) {
        DesformWidgetList desformWidgetList = map.get(string);
        if (desformWidgetList == null) {
            DesignForm designForm = this.getByCode(string);
            desformWidgetList = f.e(designForm);
            map.put(string, desformWidgetList);
        }
        for (DesformWidget desformWidget : desformWidgetList.main) {
            if (desformWidget.getType() == WidgetTypes.IMGUPLOAD || desformWidget.getType() == WidgetTypes.FILE_UPLOAD) {
                jSONObject.remove((Object)desformWidget.getModel());
            }
            if (desformWidget.getType() != WidgetTypes.DATE && desformWidget.getType() != WidgetTypes.TIME || !oConvertUtils.isEmpty((Object)jSONObject.get((Object)desformWidget.getModel()))) continue;
            jSONObject.remove((Object)desformWidget.getModel());
        }
    }

    @Override
    public Result redoAllIndexForce(String rowIds, Integer pageSize) {
        try {
            a.info("-- \u5df2\u5f00\u59cb\u5f3a\u5236\u91cd\u7f6eES\u7d22\u5f15");
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            if (oConvertUtils.isNotEmpty((Object)rowIds)) {
                lambdaQueryWrapper.in(DesignForm::getId, Arrays.asList(rowIds.split(",")));
            }
            List list = super.list((Wrapper)lambdaQueryWrapper);
            long l2 = System.currentTimeMillis();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                DesignForm designForm = (DesignForm)list.get(i2);
                String string = designForm.getDesformCode();
                a.info("---- \u6b63\u5728\u91cd\u7f6e\uff1a" + string + "\uff08\u7b2c " + (i2 + 1) + " \u4e2a/\u5171 " + list.size() + " \u4e2a\uff09");
                this.jes.removeIndex(string);
                this.jes.createIndex(string);
            }
            long l3 = System.currentTimeMillis();
            a.info("-- \u5f3a\u5236\u91cd\u7f6eES\u7d22\u5f15\u5b8c\u6210\uff0c\u5373\u5c06\u5f00\u59cb\u5feb\u901f\u91cd\u7f6e\u6570\u636e");
            a.info("-- \u603b\u8017\u65f6\uff1a" + (l3 - l2) + " ms");
            return this.redoAllIndex(rowIds, pageSize, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Result.error((String)exception.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateDefMobileViewStatus(String parentCode, String desformCode) {
        DesignForm designForm = new DesignForm();
        QueryWrapper queryWrapper = new QueryWrapper();
        designForm.setIzMobileView(org.jeecg.modules.online.desform.constant.a.b);
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"iz_mobile_view", (Object)org.jeecg.modules.online.desform.constant.a.a)).eq((Object)"desform_code", (Object)parentCode)).or()).eq((Object)"parent_code", (Object)parentCode);
        super.update((Object)designForm, (Wrapper)queryWrapper);
        designForm.setIzMobileView(org.jeecg.modules.online.desform.constant.a.a);
        queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"desform_code", (Object)desformCode);
        super.update((Object)designForm, (Wrapper)queryWrapper);
        return true;
    }

    @Override
    public void deleteRedisCache(String desformCode) {
        Set set = this.redisTemplate.keys((Object)("sys:cache:desform:byCode::" + desformCode + "*"));
        if (set != null && !set.isEmpty()) {
            this.redisTemplate.delete((Collection)set);
        }
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode + ':e-fields-1-' + #subTable")
    public JSONObject getEfficientFieldsByCode(String desformCode, boolean subTable) {
        JSONObject jSONObject = this.a(desformCode, subTable, null);
        return jSONObject;
    }

    private JSONObject a(String string, boolean bl, List<String> list) {
        DesignForm designForm = this.getByCode(string);
        if (designForm == null) {
            a.info("\u8868\u5355\uff1a" + string + " \u4e0d\u5b58\u5728\uff01");
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject jSONObject3 = JSON.parseObject((String)designForm.getDesformDesignJson());
        if (jSONObject3 == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u672a\u4fdd\u5b58\uff01");
        }
        JSONObject jSONObject4 = jSONObject3.getJSONObject("config");
        JSONArray jSONArray = jSONObject3.getJSONArray("list");
        JSONObject jSONObject5 = new JSONObject();
        jSONObject5.put("id", (Object)designForm.getId());
        jSONObject5.put("desformCode", (Object)designForm.getDesformCode());
        jSONObject5.put("desformName", (Object)designForm.getDesformName());
        jSONObject5.put("titleField", (Object)jSONObject4.getString("titleField"));
        JSONArray jSONArray2 = new JSONArray();
        HashMap hashMap = new HashMap();
        f.a(jSONArray, (widgetTypes, jSONObject, jSONObject2) -> {
            if (!bl && widgetTypes == WidgetTypes.SUB_TABLE_DESIGN) {
                return;
            }
            if (widgetTypes != WidgetTypes.SUB_TABLE_DESIGN && org.jeecg.modules.online.desform.constant.a.K.contains((Object)widgetTypes)) {
                return;
            }
            if (list != null && list.indexOf(widgetTypes.getType()) >= 0) {
                return;
            }
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("key", (Object)jSONObject.getString("key"));
            jSONObject3.put("type", (Object)jSONObject.getString("type"));
            jSONObject3.put("name", (Object)jSONObject.getString("name"));
            jSONObject3.put("model", (Object)jSONObject.getString("model"));
            jSONObject3.put("options", (Object)jSONObject.getJSONObject("options"));
            if (jSONObject.containsKey((Object)"isSubTable")) {
                jSONObject3.put("isSubTable", (Object)jSONObject.getString("isSubTable"));
            }
            if (jSONObject2 != null && WidgetTypes.SUB_TABLE_DESIGN.getType().equals(jSONObject2.getString("type"))) {
                String string = jSONObject2.getString("key");
                JSONArray jSONArray2 = (JSONArray)hashMap.get(string);
                if (jSONArray2 == null) {
                    jSONArray2 = new JSONArray();
                    hashMap.put(string, jSONArray2);
                }
                jSONArray2.add((Object)jSONObject3);
                return;
            }
            if (widgetTypes == WidgetTypes.SUB_TABLE_DESIGN) {
                String string = jSONObject.getString("key");
                JSONArray jSONArray3 = (JSONArray)hashMap.get(string);
                if (jSONArray3 == null) {
                    jSONArray3 = new JSONArray();
                    hashMap.put(string, jSONArray3);
                }
                jSONObject3.put("children", (Object)jSONArray3);
            }
            jSONArray2.add((Object)jSONObject3);
        });
        jSONObject5.put("fields", (Object)jSONArray2);
        return jSONObject5;
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode + ':e-fields-2-' + #subTable")
    public JSONObject getEfficientFieldsByCodeWithExclude(String desformCode, boolean subTable, List<String> excludeTypeList) {
        JSONObject jSONObject = this.a(desformCode, subTable, excludeTypeList);
        this.c(jSONObject);
        return jSONObject;
    }

    private void c(JSONObject jSONObject) {
        JSONArray jSONArray = jSONObject.getJSONArray("fields");
        HashMap hashMap = new HashMap();
        block0: for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
            if (!WidgetTypes.LINK_FIELD.getType().equals(jSONObject2.getString("type"))) continue;
            JSONObject jSONObject3 = jSONObject2.getJSONObject("options");
            DesformOptions desformOptions = (DesformOptions)JSONObject.parseObject((String)jSONObject3.toJSONString(), DesformOptions.class);
            String string = desformOptions.getLinkRecordKey();
            String string2 = desformOptions.getShowField();
            for (int i3 = 0; i3 < jSONArray.size(); ++i3) {
                DesformWidgetList desformWidgetList;
                Object object;
                Object object2;
                JSONObject jSONObject4 = jSONArray.getJSONObject(i3);
                String string3 = jSONObject4.getString("key");
                if (!string3.equals(string) || !WidgetTypes.LINK_RECORD.getType().equals(jSONObject4.getString("type"))) continue;
                JSONObject jSONObject5 = jSONObject4.getJSONObject("options");
                DesformOptions desformOptions2 = (DesformOptions)JSONObject.parseObject((String)jSONObject5.toJSONString(), DesformOptions.class);
                String string4 = desformOptions2.getSourceCode();
                List<DesformWidget> list = (List<DesformWidget>)hashMap.get(string4);
                if (list == null && (object2 = this.getByCode(string4)) != null) {
                    object = f.b((DesignForm)object2);
                    desformWidgetList = f.a((JSONArray)object, false);
                    list = desformWidgetList.main;
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (DesformWidget)object2.next();
                    if (!((DesformWidget)object).getModel().equals(string2)) continue;
                    desformWidgetList = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((DesformWidget)object).getOptions()));
                    jSONObject3.putAll((Map)((Object)desformWidgetList));
                    jSONObject2.put("options", (Object)jSONObject3);
                    continue block0;
                }
                continue block0;
            }
        }
    }

    @Override
    public boolean addWidgetByDesformCode(String desformCode, JSONObject widget) {
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        if (widget == null) {
            throw new JeecgBootException("widget\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String string = designForm.getDesformDesignJson();
        JSONObject jSONObject = JSON.parseObject((String)string);
        JSONArray jSONArray = jSONObject.getJSONArray("list");
        jSONArray.add((Object)widget);
        DesignForm designForm2 = new DesignForm();
        designForm2.setId(designForm.getId());
        designForm2.setDesformDesignJson(jSONObject.toJSONString());
        boolean bl = super.updateById((Object)designForm2);
        if (bl) {
            this.deleteRedisCache(desformCode);
        }
        return bl;
    }

    @Override
    public boolean updateWidgetByKeyModel(String desformCode, JSONObject setting) {
        if (setting == null) {
            throw new JeecgBootException("setting\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        String string = setting.getString("key");
        String string2 = setting.getString("model");
        boolean bl = oConvertUtils.isNotEmpty((Object)string);
        boolean bl2 = oConvertUtils.isNotEmpty((Object)string2);
        if (!bl && !bl2) {
            throw new JeecgBootException("widgetKey\u548cwidgetModel\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        String string3 = designForm.getDesformDesignJson();
        JSONObject jSONObject = JSON.parseObject((String)string3);
        JSONArray jSONArray = jSONObject.getJSONArray("list");
        JSONObject jSONObject4 = new JSONObject();
        f.a(jSONArray, (widgetTypes, jSONObject2, jSONObject3) -> {
            boolean bl3;
            String string3 = jSONObject2.getString("key");
            boolean bl4 = bl && string.equals(string3);
            String string4 = jSONObject2.getString("model");
            boolean bl5 = bl3 = bl2 && string2.equals(string4);
            if (bl4 || bl3) {
                jSONObject4.put("widget", (Object)jSONObject2);
                ArrayList<JSONArray> arrayList = new ArrayList<JSONArray>();
                if (jSONObject3 != null) {
                    WidgetTypes widgetTypes2 = WidgetTypes.getByValue(jSONObject3.getString("type"));
                    if (jSONObject3.get((Object)"columns") != null) {
                        JSONArray jSONArray2 = jSONObject3.getJSONArray("columns");
                        for (int i2 = 0; i2 < jSONArray2.size(); ++i2) {
                            JSONObject jSONObject4 = jSONArray2.getJSONObject(i2);
                            arrayList.add(jSONObject4.getJSONArray("list"));
                        }
                    } else if (WidgetTypes.CARD == widgetTypes2) {
                        arrayList.add(jSONObject3.getJSONArray("list"));
                    } else if (WidgetTypes.TABS == widgetTypes2) {
                        JSONArray jSONArray3 = jSONObject3.getJSONArray("panes");
                        for (int i3 = 0; i3 < jSONArray3.size(); ++i3) {
                            JSONObject jSONObject5 = jSONArray3.getJSONObject(i3);
                            arrayList.add(jSONObject5.getJSONArray("list"));
                        }
                    }
                } else {
                    arrayList.add(jSONArray);
                }
                jSONObject4.put("arrays", arrayList);
            }
        });
        JSONObject jSONObject5 = jSONObject4.getJSONObject("widget");
        if (jSONObject5 == null) {
            throw new JeecgBootException("\u7ec4\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        String string4 = setting.getString("action");
        boolean bl3 = "update".equals(string4);
        JSONArray jSONArray2 = jSONObject4.getJSONArray("arrays");
        for (int i2 = 0; i2 < jSONArray2.size(); ++i2) {
            JSONArray jSONArray3 = jSONArray2.getJSONArray(i2);
            for (int i3 = 0; i3 < jSONArray3.size(); ++i3) {
                boolean bl4;
                JSONObject jSONObject6 = jSONArray3.getJSONObject(i3);
                String string5 = jSONObject6.getString("key");
                boolean bl5 = bl && string.equals(string5);
                String string6 = jSONObject6.getString("model");
                boolean bl6 = bl4 = bl2 && string2.equals(string6);
                if (!bl5 && !bl4) continue;
                if (bl3) {
                    CommonUtils.mergeJSON((JSONObject)jSONObject6, (JSONObject)setting.getJSONObject("widget"));
                } else {
                    jSONArray3.remove(i3);
                }
                DesignForm designForm2 = new DesignForm();
                designForm2.setId(designForm.getId());
                designForm2.setDesformDesignJson(jSONObject.toJSONString());
                boolean bl7 = super.updateById((Object)designForm2);
                if (bl7) {
                    this.deleteRedisCache(desformCode);
                }
                return bl7;
            }
        }
        return false;
    }

    @Override
    @AutoLowApp(action=LowAppAopEnum.DESFORM_SUB2WORK, bizType="desform")
    public boolean subToWorksheet(DesignForm designForm, String subModel, DesignForm parentForm, String parentModel, String originSubCode) {
        if (designForm == null) {
            throw new JeecgBootException("designForm\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String string = designForm.getDesformCode();
        try {
            String string2 = parentForm.getDesformCode();
            if (oConvertUtils.isNotEmpty((Object)parentForm.getLowAppId())) {
                designForm.setLowAppId(parentForm.getLowAppId());
            }
            if (oConvertUtils.isNotEmpty((Object)parentForm.getTenantId())) {
                designForm.setTenantId(parentForm.getTenantId());
            }
            this.saveMain(designForm);
            List<DesignFormData> list = this.designFormDataService.list(string2, null);
            for (DesignFormData designFormData : list) {
                Object object;
                Object object2;
                Object object3 = designFormData.getDesformData().get((Object)originSubCode);
                ArrayList<DesignFormData> arrayList = null;
                if (object3 instanceof List) {
                    object2 = designFormData.getDesformData().getJSONArray(originSubCode);
                    arrayList = new ArrayList<DesignFormData>(object2.size());
                    for (int i2 = 0; i2 < object2.size(); ++i2) {
                        object = object2.getJSONObject(i2);
                        object.put(subModel, Collections.singletonList(designFormData.getId()));
                        arrayList.add(new DesignFormData(string, (JSONObject)object));
                    }
                    if (arrayList.size() > 0) {
                        this.designFormDataService.saveBatch(string, arrayList);
                    } else {
                        arrayList = null;
                    }
                }
                if (arrayList == null) continue;
                object2 = arrayList.stream().map(DesignFormData::getId).collect(Collectors.toList());
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(parentModel, object2);
                object = new DesignFormData(string2, jSONObject);
                ((DesignFormData)object).setId(designFormData.getId());
                this.designFormDataService.updateById((DesignFormData)object);
                this.designFormDataService.removeFieldById(string2, designFormData.getId(), originSubCode);
            }
            return true;
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new JeecgBootException(string + "\u5df2\u5b58\u5728");
        }
    }

    @Override
    public boolean deleteAll(String designFormCode) {
        this.designFormListViewService.deleteFormViewData(designFormCode);
        this.designFormDataService.removeByCode(designFormCode);
        this.designFormSettingService.removeByDesformCode(designFormCode);
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesignForm::getDesformCode, (Object)designFormCode);
        return this.remove((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Map<String, List<DesignFormViewVo>> queryFormByAppId(String appId) {
        List<DesignFormViewVo> list = ((DesignFormMapper)this.baseMapper).queryDesignFormListByAppId(appId);
        String string = "form";
        String string2 = "desform";
        HashMap<String, List<DesignFormViewVo>> hashMap = new HashMap<String, List<DesignFormViewVo>>();
        if (list != null && list.size() > 0) {
            List<String> list2 = list.stream().map(designFormViewVo -> {
                if (string2.equals(designFormViewVo.getType())) {
                    return designFormViewVo.getId();
                }
                if (string.equals(designFormViewVo.getType())) {
                    return designFormViewVo.getCompatibleCode();
                }
                return null;
            }).filter(oConvertUtils::isNotEmpty).collect(Collectors.toList());
            List<DesignFormViewVo> list3 = this.designFormListViewService.queryListViewByCode(list2);
            hashMap.put("viewList", list3);
        }
        hashMap.put("formList", list);
        return hashMap;
    }

    @Override
    public LowAppCopyMenu copyDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        String string = lowAppCopyMenu.getOriginFormCode();
        boolean bl = lowAppCopyMenu.isIdForm();
        DesignForm designForm = bl ? this.getByIdCache(string) : this.getByCode(string);
        if (designForm != null) {
            String string2 = designForm.getDesformCode();
            String string3 = lowAppCopyMenu.getCopyLevel();
            DesignForm designForm2 = new DesignForm();
            BeanUtils.copyProperties((Object)designForm, (Object)designForm2);
            if ("backup".equals(string3)) {
                String string4 = lowAppCopyMenu.getBackupKey();
                String string5 = LowAppCopyUtil.getBackupValue((String)designForm2.getId(), (String)string4);
                designForm2.setId(string5);
                String string6 = LowAppCopyUtil.getBackupValue((String)designForm2.getLowAppId(), (String)string4);
                designForm2.setLowAppId(string6);
                String string7 = LowAppCopyUtil.getBackupValue((String)string2, (String)string4);
                designForm2.setDesformCode(string7);
                this.save(designForm2);
                this.designFormListViewService.backupDesignFormMongo(string2, string4, "backup");
            } else {
                designForm2.setId(null);
                if ("app".equals(string3)) {
                    designForm2.setLowAppId(lowAppCopyMenu.getAppId());
                } else {
                    designForm2.setDesformName(designForm.getDesformName() + "-\u590d\u5236");
                }
                String string8 = this.a(string2);
                designForm2.setDesformCode(string8);
                this.save(designForm2);
                Map<String, String> map = this.designFormListViewService.copyDesignFormMongo(string2, string8);
                lowAppCopyMenu.setViewIdMapping(map);
                if (bl) {
                    lowAppCopyMenu.setNewFormCode(designForm2.getId());
                } else {
                    lowAppCopyMenu.setNewFormCode(string8);
                }
            }
        }
        return lowAppCopyMenu;
    }

    @Override
    @CacheEvict(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode")
    public void updateDesignFormJson(String desformCode, Map<String, String> codeMapping) {
        String string;
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DesignForm::getDesformCode, (Object)desformCode);
        DesignForm designForm = (DesignForm)((DesignFormMapper)this.baseMapper).selectOne((Wrapper)lambdaQueryWrapper);
        if (designForm != null && oConvertUtils.isNotEmpty((Object)(string = designForm.getDesformDesignJson()))) {
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            JSONArray jSONArray = jSONObject.getJSONArray("list");
            block0: for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                String string2 = jSONObject2.getString("type");
                if (!WidgetTypes.LINK_RECORD.getType().equals(string2)) continue;
                JSONObject jSONObject3 = jSONObject2.getJSONObject("options");
                String string3 = jSONObject3.getString("sourceCode");
                for (String string4 : codeMapping.keySet()) {
                    if (!string4.equals(string3)) continue;
                    jSONObject3.put("sourceCode", (Object)codeMapping.get(string4));
                    continue block0;
                }
            }
            designForm.setDesformDesignJson(jSONObject.toJSONString());
            ((DesignFormMapper)this.baseMapper).updateById(designForm);
        }
    }

    @Override
    @CacheEvict(cacheNames={"sys:cache:desform:byCode"}, key="#lowAppCopyMenu.originFormCode")
    public void coverDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        String string;
        String string2;
        DesignForm designForm;
        String string3 = lowAppCopyMenu.getOriginFormCode();
        DesignForm designForm2 = this.getByCode(string3);
        if (designForm2 != null && (designForm = this.getByCode(string2 = LowAppCopyUtil.getBackupValue((String)string3, (String)(string = lowAppCopyMenu.getBackupKey())))) != null) {
            String string4 = designForm2.getId();
            BeanUtils.copyProperties((Object)designForm, (Object)designForm2);
            designForm2.setId(string4);
            designForm2.setDesformCode(string3);
            String string5 = LowAppCopyUtil.getOriginValue((String)designForm2.getLowAppId(), (String)string);
            designForm2.setLowAppId(string5);
            this.updateById(designForm2);
            this.designFormListViewService.backupDesignFormMongo(string2, string, "cover");
        }
    }

    private String a(String string) {
        String string2 = null;
        String string3 = "copy";
        String string4 = "_";
        String string5 = oConvertUtils.randomGen((int)4).toLowerCase();
        if (string.endsWith(string3) && string.indexOf(string4) >= 0) {
            String string6 = string.substring(0, string.lastIndexOf(string4));
            string2 = string6 + string4 + string5 + string3;
        } else {
            string2 = string + string4 + string5 + string3;
        }
        return string2;
    }

    private static /* synthetic */ Object a(SerializedLambda serializedLambda) {
        switch (serializedLambda.getImplMethodName()) {
            case "getDesformId": {
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormData::getDesformId;
            }
            case "getId": {
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getId;
                }
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getId;
                }
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignForm::getId;
            }
            case "getDesformCode": {
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignForm::getDesformCode;
            }
            case "getIzMobileView": {
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) break;
                return DesignForm::getIzMobileView;
            }
            case "getParentCode": {
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignForm::getParentCode;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

