/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.transl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.c.e;
import org.jeecg.modules.online.desform.vo.TranslateData;
import org.jeecg.modules.online.desform.vo.widget.DesformOptions;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.jeecg.modules.online.desform.vo.widget.options.DesformConfItem;

public class TranslAllData {
    private List<String> dictCodeList = new ArrayList<String>();
    List<TranslateData> userDepartList = new ArrayList<TranslateData>();
    List<TranslateData> tableDictList1 = new ArrayList<TranslateData>();
    List<TranslateData> tableDictList2 = new ArrayList<TranslateData>();
    TranslateData selectTreeData1 = null;
    List<TranslateData> selectTreeList2 = new ArrayList<TranslateData>();

    public void packageTranslAllData(DesformWidget widget, String data) {
        switch (widget.getType()) {
            case SELECT: 
            case CHECKBOX: 
            case RADIO: {
                this.addDictCode(widget);
                break;
            }
            case SELECT_DEPART: 
            case SELECT_USER: {
                this.addUserDepartData(widget, data);
                break;
            }
            case TABLE_DICT: {
                this.addTableDictData(widget, data);
                break;
            }
            case SELECT_TREE: {
                this.addSelectTreeData(widget, data);
            }
        }
    }

    public void addDictCode(DesformWidget widget) {
        String string = widget.getOptions().getRemote();
        String string2 = widget.getOptions().getDictCode();
        if ("dict".equals(string) && oConvertUtils.isNotEmpty((Object)string2)) {
            if (this.dictCodeList.stream().noneMatch(string2::equals)) {
                this.dictCodeList.add(string2);
            }
        }
    }

    public void addUserDepartData(DesformWidget widget, String data) {
        DesformOptions desformOptions = widget.getOptions();
        List<String> list = Arrays.asList("id", "username", "orgCode");
        if (list.contains(desformOptions.getCustomReturnField())) {
            TranslateData translateData = e.a(widget, data);
            translateData.setCustomReturnField(desformOptions.getCustomReturnField());
            this.userDepartList.add(translateData);
        }
    }

    public void addTableDictData(DesformWidget widget, String data) {
        DesformOptions desformOptions = widget.getOptions();
        if ("select".equals(desformOptions.getStyle())) {
            String string = desformOptions.getDictTable() + "," + desformOptions.getDictText() + "," + desformOptions.getDictCode();
            switch (desformOptions.getQueryScope()) {
                case "database": {
                    this.addTranslateData(widget, data, this.tableDictList2).setDictCode(string);
                    break;
                }
                default: {
                    this.addTranslateData(widget, data, this.tableDictList1, t -> t.getDictCode().equals(string)).setDictCode(string);
                }
            }
        }
    }

    private TranslateData addTranslateData(DesformWidget widget, String data, List<TranslateData> list) {
        return this.addTranslateData(widget, data, list, t -> t.getKey().equals(widget.getKey()));
    }

    private TranslateData addTranslateData(DesformWidget widget, String data, List<TranslateData> list, Predicate<TranslateData> predicate) {
        Optional<TranslateData> optional = list.stream().filter(predicate).findFirst();
        if (optional.isPresent()) {
            TranslateData translateData = optional.get();
            translateData.getDataList().addAll(Arrays.asList(data.split(",")));
            return translateData;
        }
        TranslateData translateData = e.a(widget, data);
        list.add(translateData);
        return translateData;
    }

    public void addSelectTreeData(DesformWidget widget, String data) {
        String[] stringArray = data.split(",");
        DesformOptions desformOptions = widget.getOptions();
        switch (desformOptions.getDataFrom()) {
            case "table": {
                DesformConfItem desformConfItem = desformOptions.getConf().getTable();
                String string = desformConfItem.getName() + "," + desformConfItem.getText() + "," + desformConfItem.getCode();
                for (String string2 : stringArray) {
                    this.addTranslateData(widget, string2, this.selectTreeList2).setDictCode(string);
                }
                break;
            }
            default: {
                if (this.selectTreeData1 == null) {
                    this.selectTreeData1 = e.a(widget, data);
                    this.selectTreeData1.setKey("sys_category");
                }
                this.selectTreeData1.getDataList().addAll(Arrays.asList(stringArray));
            }
        }
    }

    public List<String> getDictCodeList() {
        return this.dictCodeList;
    }

    public List<TranslateData> getUserDepartList() {
        return this.userDepartList;
    }

    public List<TranslateData> getTableDictList1() {
        return this.tableDictList1;
    }

    public List<TranslateData> getTableDictList2() {
        return this.tableDictList2;
    }

    public TranslateData getSelectTreeData1() {
        return this.selectTreeData1;
    }

    public List<TranslateData> getSelectTreeList2() {
        return this.selectTreeList2;
    }
}

