/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.aspect;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.aspect.annotation.AutoLowApp;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.entity.OnlCgformHead;
import org.jeecg.modules.online.cgform.enums.CgformConstant;
import org.jeecg.modules.online.cgform.model.a;
import org.jeecg.modules.online.cgform.service.IOnlCgformHeadService;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportHead;
import org.jeecg.modules.online.cgreport.model.OnlCgreportModel;
import org.jeecg.modules.online.graphreport.vo.OnlGraphreportHeadPage;
import org.jeecg.modules.online.low.entity.LowAppMenu;
import org.jeecg.modules.online.low.service.ILowAppMenuService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="lowAppAspect")
public class LowAppAspect {
    private static final Logger log = LoggerFactory.getLogger(LowAppAspect.class);
    @Autowired
    ILowAppMenuService appMenuService;
    @Autowired
    IOnlCgformHeadService cgformHeadService;

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.AutoLowApp)")
    public void excudeLowAppAspect() {
    }

    @Around(value="excudeLowAppAspect() && @annotation(autoLowApp)")
    public Object excudeLowAppAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        switch (autoLowApp.action()) {
            case ADD: {
                return this.autoAddAspect(pjp, autoLowApp);
            }
            case DELETE: {
                return this.autoDeleteAspect(pjp, autoLowApp);
            }
            case CGFORM_DB_IMPORT: {
                return this.doExcudeCgformSaveDbTable2Online(pjp);
            }
        }
        return pjp.proceed();
    }

    private Object autoAddAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        switch (autoLowApp.bizType()) {
            case "cgform": {
                return this.doExcudeCgformAdd(pjp);
            }
            case "desform": {
                return this.doExcudeDesignAdd(pjp);
            }
            case "cgreport": {
                return this.doExcudeCgreportAdd(pjp);
            }
            case "graphreport": {
                return this.doExcudeGraphreportAdd(pjp);
            }
        }
        return pjp.proceed();
    }

    private Object autoDeleteAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        Object object = null;
        try {
            object = this.autoDeleteMenu(pjp, autoLowApp.bizType());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object doExcudeDesignAdd(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Object[] objectArray = pjp.getArgs();
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object object = objectArray[0];
                Class<?> clazz = object.getClass();
                clazz.getMethod("setLowAppId", String.class).invoke(object, string);
                String string2 = clazz.getMethod("getDesformName", new Class[0]).invoke(object, new Object[0]).toString();
                String string3 = clazz.getMethod("getDesformCode", new Class[0]).invoke(object, new Object[0]).toString();
                this.saveLowAppMenu(string, string2, string3, "desform");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return pjp.proceed();
    }

    private Object doExcudeCgreportAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object[] objectArray = pjp.getArgs();
                OnlCgreportModel onlCgreportModel = (OnlCgreportModel)objectArray[0];
                OnlCgreportHead onlCgreportHead = onlCgreportModel.getHead();
                onlCgreportHead.setLowAppId(string);
                object = pjp.proceed();
                this.saveLowAppMenu(string, onlCgreportHead.getName(), onlCgreportHead.getId(), "cgreport");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object doExcudeGraphreportAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object[] objectArray = pjp.getArgs();
                OnlGraphreportHeadPage onlGraphreportHeadPage = (OnlGraphreportHeadPage)objectArray[0];
                onlGraphreportHeadPage.setLowAppId(string);
                object = pjp.proceed();
                this.saveLowAppMenu(string, onlGraphreportHeadPage.getName(), onlGraphreportHeadPage.getId(), "graphreport");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object doExcudeCgformAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object[] objectArray = pjp.getArgs();
                a a2 = (a)objectArray[0];
                OnlCgformHead onlCgformHead = a2.getHead();
                onlCgformHead.setLowAppId(string);
                object = pjp.proceed();
                if (!CgformConstant.ONLINE_TABLE_TYPE_SUB.equals(onlCgformHead.getTableType())) {
                    this.saveLowAppMenu(string, onlCgformHead.getTableTxt(), onlCgformHead.getId(), "cgform");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private void saveLowAppMenu(String lowAppId, String menuName, String menuUrl, String type) {
        LowAppMenu lowAppMenu = new LowAppMenu();
        lowAppMenu.setAppId(lowAppId);
        lowAppMenu.setType(type);
        lowAppMenu.setMenuName(menuName);
        lowAppMenu.setMenuUrl(menuUrl);
        lowAppMenu.setDelFlag(CommonConstant.DEL_FLAG_0);
        this.appMenuService.saveMenu(lowAppMenu);
    }

    private boolean removeByMenuUrl(String[] menuUrls, String type) {
        if ("desform".equals(type)) {
            return this.appMenuService.forceRemoveByDesformId(Arrays.asList(menuUrls));
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(LowAppMenu::getType, (Object)type);
        lambdaQueryWrapper.in(LowAppMenu::getMenuUrl, Arrays.asList(menuUrls));
        return this.appMenuService.forceRemove((LambdaQueryWrapper<LowAppMenu>)lambdaQueryWrapper);
    }

    private Object autoDeleteMenu(ProceedingJoinPoint pjp, String type) throws Throwable {
        HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
        String string = httpServletRequest.getHeader("X-Low-App-ID");
        if (oConvertUtils.isNotEmpty((Object)string)) {
            Signature signature = pjp.getSignature();
            Method method = ((MethodSignature)signature).getMethod();
            Object[] objectArray = pjp.getArgs();
            String string2 = (String)objectArray[0];
            String[] stringArray = "deleteBatch".equals(method.getName()) ? string2.split(",") : new String[]{string2};
            this.removeByMenuUrl(stringArray, type);
            return pjp.proceed();
        }
        return null;
    }

    private Object doExcudeCgformSaveDbTable2Online(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
        Object object = pjp.proceed();
        String string = httpServletRequest.getHeader("X-Low-App-ID");
        if (oConvertUtils.isNotEmpty((Object)string)) {
            Object object2 = pjp.getArgs()[0];
            OnlCgformHead onlCgformHead = new OnlCgformHead();
            onlCgformHead.setLowAppId(string);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(OnlCgformHead::getTableName, object2);
            this.cgformHeadService.update(onlCgformHead, (Wrapper)lambdaQueryWrapper);
        }
        return object;
    }
}

