/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.graphreport.service.a;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportHead;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportItem;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportParams;
import org.jeecg.modules.online.graphreport.mapper.OnlGraphreportHeadMapper;
import org.jeecg.modules.online.graphreport.mapper.OnlGraphreportItemMapper;
import org.jeecg.modules.online.graphreport.mapper.OnlGraphreportParamsMapper;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportHeadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="onlGraphreportHeadServiceImpl")
public class b
extends ServiceImpl<OnlGraphreportHeadMapper, OnlGraphreportHead>
implements IOnlGraphreportHeadService {
    @Autowired
    private OnlGraphreportHeadMapper onlGraphreportHeadMapper;
    @Autowired
    private OnlGraphreportItemMapper onlGraphreportItemMapper;
    @Autowired
    private OnlGraphreportParamsMapper onlGraphreportParamsMapper;
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    @Override
    public List<Map<String, Object>> executeSelete(String sql) {
        return this.onlGraphreportHeadMapper.executeSelete(sql);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(OnlGraphreportHead onlGraphreportHead, List<OnlGraphreportItem> onlGraphreportItemList, List<OnlGraphreportParams> paramsList) {
        if (onlGraphreportHead.getYaxisText() == null) {
            onlGraphreportHead.setYaxisText("yaxis_text");
        }
        this.onlGraphreportHeadMapper.insert(onlGraphreportHead);
        for (OnlGraphreportItem serializable : onlGraphreportItemList) {
            serializable.setGraphreportHeadId(onlGraphreportHead.getId());
            this.onlGraphreportItemMapper.insert(serializable);
        }
        for (OnlGraphreportParams onlGraphreportParams : paramsList) {
            onlGraphreportParams.setHeadId(onlGraphreportHead.getId());
            this.onlGraphreportParamsMapper.insert(onlGraphreportParams);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMain(OnlGraphreportHead onlGraphreportHead, List<OnlGraphreportItem> onlGraphreportItemList, List<OnlGraphreportParams> paramsList) {
        this.onlGraphreportHeadMapper.updateById(onlGraphreportHead);
        this.onlGraphreportItemMapper.deleteByMainId(onlGraphreportHead.getId());
        this.onlGraphreportParamsMapper.deleteByMainId(onlGraphreportHead.getId());
        for (OnlGraphreportItem serializable : onlGraphreportItemList) {
            serializable.setGraphreportHeadId(onlGraphreportHead.getId());
            this.onlGraphreportItemMapper.insert(serializable);
        }
        for (OnlGraphreportParams onlGraphreportParams : paramsList) {
            onlGraphreportParams.setHeadId(onlGraphreportHead.getId());
            this.onlGraphreportParamsMapper.insert(onlGraphreportParams);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        this.onlGraphreportHeadMapper.deleteById((Serializable)((Object)id));
        this.onlGraphreportItemMapper.deleteByMainId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delBatchMain(Collection<? extends Serializable> idList) {
        for (Serializable serializable : idList) {
            this.onlGraphreportHeadMapper.deleteById(serializable);
            this.onlGraphreportItemMapper.deleteByMainId(serializable.toString());
        }
    }

    @Override
    public OnlGraphreportHead queryByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        return (OnlGraphreportHead)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"sys:cache:online:graph"}, key="#head.id")
    public Map<String, Object> queryChartConfig(OnlGraphreportHead head) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("head", head);
        if (head.getYaxisField() != null) {
            head.setYaxisField(head.getYaxisField().toLowerCase());
        }
        if (head.getXaxisField() != null) {
            head.setXaxisField(head.getXaxisField().toLowerCase());
        }
        List<OnlGraphreportItem> list = this.onlGraphreportItemMapper.selectByMainId(head.getId());
        for (OnlGraphreportItem object : list) {
            if (object.getFieldName() == null) continue;
            object.setFieldName(object.getFieldName().toLowerCase());
        }
        HashMap hashMap2 = new HashMap(0);
        for (OnlGraphreportItem onlGraphreportItem : list) {
            String string = onlGraphreportItem.getDictCode();
            if (StringUtils.isEmpty((String)string)) continue;
            List list2 = null;
            if (string.toLowerCase().trim().indexOf("select ") == 0) {
                List<Map<String, Object>> list3 = this.executeSelete(string);
                if (list3 != null && list3.size() != 0) {
                    String string2 = JSON.toJSONString(list3);
                    list2 = JSON.parseArray((String)string2, DictModel.class);
                }
            } else {
                list2 = this.sysBaseAPI.queryDictItemsByCode(string);
            }
            hashMap2.put(onlGraphreportItem.getFieldName(), list2);
        }
        hashMap.put("items", list);
        hashMap.put("dictOptions", hashMap2);
        return hashMap;
    }
}

