/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.export.ActivitiListenerExport;
import org.activiti.bpmn.converter.export.LaneExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang3.StringUtils;

public class ProcessExport
implements BpmnXMLConstants {
    public static final List<ExtensionAttribute> defaultProcessAttributes = Arrays.asList(new ExtensionAttribute("id"), new ExtensionAttribute("name"), new ExtensionAttribute("isExecutable"), new ExtensionAttribute("http://activiti.org/bpmn", "candidateStarterUsers"), new ExtensionAttribute("http://activiti.org/bpmn", "candidateStarterGroups"));

    public static void writeProcess(Process process, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("process");
        xtw.writeAttribute("id", process.getId());
        if (StringUtils.isNotEmpty((CharSequence)process.getName())) {
            xtw.writeAttribute("name", process.getName());
        }
        xtw.writeAttribute("isExecutable", Boolean.toString(process.isExecutable()));
        if (process.getCandidateStarterUsers().size() > 0) {
            xtw.writeAttribute("activiti", "http://activiti.org/bpmn", "candidateStarterUsers", BpmnXMLUtil.convertToDelimitedString(process.getCandidateStarterUsers()));
        }
        if (process.getCandidateStarterGroups().size() > 0) {
            xtw.writeAttribute("activiti", "http://activiti.org/bpmn", "candidateStarterGroups", BpmnXMLUtil.convertToDelimitedString(process.getCandidateStarterGroups()));
        }
        BpmnXMLUtil.writeCustomAttributes(process.getAttributes().values(), xtw, defaultProcessAttributes);
        if (StringUtils.isNotEmpty((CharSequence)process.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(process.getDocumentation());
            xtw.writeEndElement();
        }
        boolean didWriteExtensionStartElement = ActivitiListenerExport.writeListeners((BaseElement)process, false, xtw);
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)process, didWriteExtensionStartElement, xtw)) {
            xtw.writeEndElement();
        }
        LaneExport.writeLanes(process, xtw);
    }
}

