/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.web.model;

import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model<M extends Model>
extends com.jfinal.plugin.activerecord.Model<M> {
    private Table table;
    private String tableName;
    private String primaryKey;
    private String modelName;
    private String selectSql;
    private String fromSql;
    private String updateSql;
    private String deleteSql;
    private String dropSql;
    private String countSql;
    protected static String blank = " ";

    public Map<String, Object> getAttrs() {
        return super.getAttrs();
    }

    public String getJson() {
        return JsonKit.toJson((Object)((Object)this));
    }

    public List<M> findAll() {
        return this.find(this.getSelectSql() + this.getFromSql());
    }

    public List<M> findBy(String where, Object ... paras) {
        return this.find(this.getSelectSql() + this.getFromSql() + this.getWhere(where), paras);
    }

    public List<M> findTopBy(int topNumber, String where, Object ... paras) {
        return this.paginate(1, topNumber, this.getSelectSql(), this.getFromSql() + this.getWhere(where), paras).getList();
    }

    public M findFirstBy(String where, Object ... paras) {
        return (M)((Object)((Model)this.findFirst(this.getSelectSql() + this.getFromSql() + this.getWhere(where), paras)));
    }

    public Page<M> paginateAll(int pageNumber, int pageSize) {
        return this.paginate(pageNumber, pageSize, this.getSelectSql(), this.getFromSql());
    }

    public Page<M> paginateBy(int pageNumber, int pageSize, String where, Object ... paras) {
        return this.paginate(pageNumber, pageSize, this.getSelectSql(), this.getFromSql() + this.getWhere(where), paras);
    }

    public boolean updateAll(String set, Object ... paras) {
        return Db.update((String)(this.getUpdateSql() + this.getSet(set)), (Object[])paras) > 0;
    }

    public boolean updateBy(String set, String where, Object ... paras) {
        return Db.update((String)(this.getUpdateSql() + this.getSet(set) + this.getWhere(where)), (Object[])paras) > 0;
    }

    public boolean deleteAll() {
        return Db.update((String)this.getDeleteSql(), (Object[])new Object[]{new Date()}) > 0;
    }

    public boolean deleteBy(String where, Object ... paras) {
        Object[] realParas = new Object[paras.length + 1];
        realParas[0] = new Date();
        for (int i = 0; i < paras.length; ++i) {
            realParas[i + 1] = paras[i];
        }
        return Db.update((String)(this.getDeleteSql() + this.getWhere(where)), (Object[])realParas) > 0;
    }

    public boolean dropAll() {
        return Db.update((String)this.getDropSql()) > 0;
    }

    public boolean dropBy(String where, Object ... paras) {
        return Db.update((String)(this.getDropSql() + this.getWhere(where)), (Object[])paras) > 0;
    }

    public Long countAll() {
        return (Long)Db.queryFirst((String)this.getCountSql());
    }

    public Long countBy(String where, Object ... paras) {
        return (Long)Db.queryFirst((String)(this.getCountSql() + this.getWhere(where)), (Object[])paras);
    }

    protected String getSet(String set) {
        if (set != null && !set.isEmpty() && !set.trim().toUpperCase().startsWith("SET")) {
            set = " SET " + set;
        }
        return set;
    }

    protected String getWhere(String where) {
        if (where != null && !where.isEmpty() && !where.trim().toUpperCase().startsWith("WHERE")) {
            where = " WHERE " + where;
        }
        return where;
    }

    public Table getTable() {
        if (this.table == null) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            this.table = TableMapping.me().getTable(clazz);
        }
        return this.table;
    }

    public String getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = this.getTable().getPrimaryKey();
        }
        return this.primaryKey;
    }

    public String getTableName() {
        if (this.tableName == null) {
            this.tableName = this.getTable().getName();
        }
        return this.tableName;
    }

    public String getModelName() {
        if (this.modelName == null) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            byte[] items = clazz.getSimpleName().getBytes();
            items[0] = (byte)((char)items[0] + 32);
            this.modelName = new String(items);
        }
        return this.modelName;
    }

    public String getSelectSql() {
        if (this.selectSql == null) {
            this.selectSql = " SELECT `" + this.getModelName() + "`.* ";
        }
        return this.selectSql;
    }

    public String getFromSql() {
        if (this.fromSql == null) {
            this.fromSql = " FROM " + this.getTableName() + " `" + this.getModelName() + "` ";
        }
        return this.fromSql;
    }

    public String getUpdateSql() {
        if (this.updateSql == null) {
            this.updateSql = " UPDATE " + this.getTableName() + " `" + this.getModelName() + "` ";
        }
        return this.updateSql;
    }

    public String getDeleteSql() {
        if (this.deleteSql == null) {
            this.deleteSql = " UPDATE " + this.getTableName() + " `" + this.getModelName() + "` SET `" + this.getModelName() + "`.deleted_at=? ";
        }
        return this.deleteSql;
    }

    public String getDropSql() {
        if (this.dropSql == null) {
            this.dropSql = " DELETE FROM " + this.getTableName() + " ";
        }
        return this.dropSql;
    }

    public String getCountSql() {
        if (this.countSql == null) {
            this.countSql = " SELECT COUNT(*) count FROM " + this.getTableName() + " `" + this.getModelName() + "` ";
        }
        return this.countSql;
    }

    public String getNextSql(String where) {
        String nextSql = " WHERE `" + this.getModelName() + "`." + this.getPrimaryKey() + "=(SELECT MIN(`_" + this.getModelName() + "`." + this.getPrimaryKey() + ") FROM " + this.getTableName() + " `_" + this.getModelName() + "`" + this.getWhere(where) + ")";
        return nextSql;
    }

    public String getPreviousSql(String where) {
        String previousSql = " WHERE `" + this.getModelName() + "`." + this.getPrimaryKey() + "=(SELECT MAX(`_" + this.getModelName() + "`." + this.getPrimaryKey() + ") FROM " + this.getTableName() + " `_" + this.getModelName() + "`" + this.getWhere(where) + ")";
        return previousSql;
    }
}

