/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.web.filter;

import cn.dreampie.web.filter.HttpFilter;
import cn.dreampie.web.filter.ThreadLocalKit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThreadLocalFilter
extends HttpFilter {
    private boolean autoJson = true;
    private List<String> excludes = new ArrayList<String>(){
        {
            this.add("*.js");
            this.add("*.css");
            this.add("*.png");
            this.add("*.gif");
            this.add("*.jpg");
        }
    };

    public void init(FilterConfig filterConfig) throws ServletException {
        String s;
        FilterConfig config = filterConfig;
        String dataTypeName = filterConfig.getInitParameter("dataTypeName");
        if (dataTypeName != null && !dataTypeName.isEmpty()) {
            ThreadLocalKit.setDataTypeName(dataTypeName);
        }
        if ((s = config.getInitParameter("excludes")) != null) {
            String[] ary;
            for (String a : ary = s.split(",")) {
                this.excludes.add(a.trim());
            }
        }
        this.autoJson = Boolean.valueOf(config.getInitParameter("autoJson"));
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = request.getRequestURI();
        boolean excluding = false;
        if (!uri.equals("/")) {
            String[] patts = null;
            for (String exclude : this.excludes) {
                if (exclude.startsWith("*")) {
                    if (!uri.endsWith(exclude.replaceFirst("\\*", ""))) continue;
                    excluding = true;
                    break;
                }
                patts = exclude.split("\\*");
                if (patts.length == 1 && uri.startsWith(patts[0])) {
                    excluding = true;
                    break;
                }
                if (patts.length != 2 || !uri.startsWith(patts[0]) || !uri.endsWith(patts[1])) continue;
                excluding = true;
                break;
            }
        }
        if (!excluding) {
            ThreadLocalKit.init(request, this.autoJson);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

