/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.ApplianceException;
import org.apache.avalon.activation.appliance.ApplianceFactory;
import org.apache.avalon.activation.appliance.impl.ContainmentAppliance;
import org.apache.avalon.activation.appliance.impl.PooledAppliance;
import org.apache.avalon.activation.appliance.impl.SingletonAppliance;
import org.apache.avalon.activation.appliance.impl.ThreadAppliance;
import org.apache.avalon.activation.appliance.impl.TransientAppliance;
import org.apache.avalon.composition.logging.LoggingManager;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.Model;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.mpool.PoolManager;

public class DefaultApplianceFactory
extends AbstractLogEnabled
implements ApplianceFactory,
Contextualizable {
    private Context m_context;
    private PoolManager m_pool;
    private LoggingManager m_logging;

    public void contextualize(Context context) throws ContextException {
        this.m_context = context;
        this.m_pool = (PoolManager)context.get((Object)PoolManager.ROLE);
        this.m_logging = (LoggingManager)context.get((Object)"urn:assembly:logging");
    }

    public Appliance createAppliance(Model model) throws ApplianceException {
        String path = model.getPath() + model.getName();
        Logger logger = this.m_logging.getSystemLoggerForCategory(path);
        if (model instanceof DeploymentModel) {
            DeploymentModel deployment = (DeploymentModel)model;
            String lifestyle = deployment.getType().getInfo().getLifestyle();
            logger.info("creating " + lifestyle + " appliance: " + path);
            if (lifestyle.equals("transient")) {
                return new TransientAppliance(logger, (Model)deployment);
            }
            if (lifestyle.equals("singleton")) {
                return new SingletonAppliance(logger, (Model)deployment);
            }
            if (lifestyle.equals("thread")) {
                return new ThreadAppliance(logger, (Model)deployment);
            }
            if (lifestyle.equals("pooled")) {
                return new PooledAppliance(logger, (Model)deployment);
            }
            return new TransientAppliance(logger, (Model)deployment);
        }
        if (model instanceof ContainmentModel) {
            logger.info("creating containment context: " + path);
            ContainmentModel containment = (ContainmentModel)model;
            return new ContainmentAppliance(logger, containment, this.createFactory(containment));
        }
        String error = "Unrecognized model: " + model.getClass().getName();
        throw new IllegalArgumentException(error);
    }

    private ApplianceFactory createFactory(ContainmentModel model) throws ApplianceException {
        String path = model.getPath() + model.getName();
        try {
            DefaultApplianceFactory factory = new DefaultApplianceFactory();
            String category = path + ".factory";
            factory.enableLogging(this.m_logging.getSystemLoggerForCategory(path));
            factory.contextualize(this.m_context);
            return factory;
        }
        catch (Throwable e) {
            String error = "Internal error while building a subsidary factory: " + path;
            throw new ApplianceException(error, e);
        }
    }
}

